## ---- echo = FALSE, message = FALSE---------------------------------------------------------------
library(markdown)
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    fig.align = "center")
options(width = 100)
options(rmarkdown.html_vignette.check_title = FALSE)
library(cola)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  # code only for demonstration
#  mat = adjust_matrix(mat)  # optional
#  rl = run_all_consensus_partition_methods(mat, mc.cores = ...)
#  cola_report(rl, output_dir = ..., mc.cores = ...)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  res = consensus_partition(mat, top_value_method = ..., partition_method = ...)
#  cola_report(res, output_dir = ..., mc.cores = ...)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  res = consensus_partition_by_down_sampling(mat, subset = ...,
#      top_value_method = ..., partition_method = ...)
#  cola_report(res, output_dir = ..., mc.cores = ...)

