## ----setup, echo=FALSE, results="hide"----------------------------------------
library(TxRegInfra)

## ----lkshi--------------------------------------------------------------------
cm = TxRegInfra:::basicCfieldsMap()
cmdf = as.data.frame(cm)
names(cmdf) = names(cm)
cmdf

## ----makecon------------------------------------------------------------------
con1 = mongo(url=URL_txregInAWS(), db="txregnet")
cd = TxRegInfra::basicColData
rme0 = RaggedMongoExpt(con1, colData=cd)
rme0

## ----lkcon1-------------------------------------------------------------------
mycon = mongo(db="txregnet", 
   url=URL_txregInAWS(),   # ATLAS deployment in AWS
   collection="Lung_allpairs_v7_eQTL")
mycon$find(q=rjson::toJSON(list(chr=17)), limit=2)

## ----dosb---------------------------------------------------------------------
lname_eqtl = "Lung_allpairs_v7_eQTL"
lname_dhs = "ENCFF001SSA_hg19_HS" # see dnmeta
lname_fp = "fLung_DS14724_hg19_FP"
si17 = GenomeInfoDb::Seqinfo(genome="hg19")["chr17"]
si17n = si17
GenomeInfoDb::seqlevelsStyle(si17n) = "NCBI"
s1 = sbov(rme0[,lname_eqtl], GRanges("17", IRanges(38.06e6, 38.15e6),
    seqinfo=si17n))
s2 = sbov(rme0[,lname_dhs], GRanges("chr17", IRanges(38.06e6, 38.15e6),
   seqinfo=si17))
s3 = sbov(rme0[,lname_fp], GRanges("chr17", IRanges(38.06e6, 38.15e6),
   seqinfo=si17))

