## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ---- eval=FALSE--------------------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("SpatialExperiment")

## ---- message=FALSE-----------------------------------------------------------
library("SpatialExperiment")
library("Matrix")
library("rjson")

## -----------------------------------------------------------------------------
barcodesFile <- system.file(file.path("extdata", "10x_visium",
                            "barcodes.tsv"), package="SpatialExperiment")
barcodesEx <- read.csv(barcodesFile, sep="\t", 
                     header=FALSE, col.names=c("Cell_ID"))
featuresFile <- system.file(file.path("extdata", "10x_visium",
                            "features.tsv"), package="SpatialExperiment")
featuresEx <- read.csv(featuresFile, sep="\t", 
                     header=FALSE, col.names=c("Feature_ID", "Feature_name", 
                                               "Feature_type"))

countsFile <- system.file(file.path("extdata", "10x_visium",
                            "matrix.mtx"), package="SpatialExperiment")
countsEx <- readMM(file=countsFile)


## -----------------------------------------------------------------------------
posFile <- system.file(file.path("extdata", "10x_visium",
                        "tissue_positions_list.tsv"), 
                        package="SpatialExperiment")
tissPosEx <- read.csv(posFile, 
                        sep="\t", header=FALSE, 
                        col.names=c("Cell_ID", "in_tissue", 
                                    "array_row", "array_col",
                                    "pxl_col_in_fullres", "pxl_row_in_fullres"))

## -----------------------------------------------------------------------------
imageFilePath <- list.files(system.file(file.path("extdata", "10x_visium", 
                              "images"), package="SpatialExperiment"), 
                            full.names=TRUE)

## -----------------------------------------------------------------------------
scaleFile <- system.file(file.path("extdata", "10x_visium",
                        "scalefactors_json.json"), 
                        package="SpatialExperiment")

scalefactors <- fromJSON(file=scaleFile)

## -----------------------------------------------------------------------------
ve <- VisiumExperiment(rowData=featuresEx, colData=barcodesEx, 
                            assays=c(counts=countsEx), 
                            spatialCoords=tissPosEx,
                            scaleFactors=scalefactors)
ve

## -----------------------------------------------------------------------------
spatialCoords(ve)

## -----------------------------------------------------------------------------
imagePaths(ve) <- imageFilePath
imagePaths(ve)

## -----------------------------------------------------------------------------
scaleFactors(ve)

## -----------------------------------------------------------------------------
sum(isInTissue(ve))
ve[isInTissue(ve)]

## -----------------------------------------------------------------------------
sessionInfo()

