/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.mascotdatfile.util.mascot.quantitation;

import com.compomics.mascotdatfile.util.mascot.Peak;
import com.compomics.mascotdatfile.util.mascot.enumeration.Mass;
import com.compomics.mascotdatfile.util.mascot.quantitation.Component;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Ratio {
    private static Logger logger = Logger.getLogger(Ratio.class);
    public static double NUMERATOR_NOT_FOUND = -1.0;
    public static double DENOMINATOR_NOT_FOUND = -2.0;
    public static double NUMERATOR_AND_DENOMINATOR_NOT_FOUND = -3.0;
    private Component iNumerator;
    private Component iDenominator;
    private double iNumeratorCoefficient = 1.0;
    private double iDenominatorCoefficient = 1.0;

    public Ratio(Component aNumeratorComponent, Component aDenominatorComponent) {
        this(aNumeratorComponent, aDenominatorComponent, 1.0, 1.0);
    }

    public Ratio(Component aNumeratorComponent, Component aDenominatorComponent, Double aNumeratorCoeficient, Double aDenominatorCoeficient) {
        this.iNumerator = aNumeratorComponent;
        this.iNumeratorCoefficient = aNumeratorCoeficient;
        this.iDenominator = aDenominatorComponent;
        this.iDenominatorCoefficient = aDenominatorCoeficient;
    }

    public String getName() {
        return this.iNumerator.getName() + (this.iNumeratorCoefficient != 1.0 ? " x " + this.iNumeratorCoefficient : "") + "/" + this.iDenominator.getName() + (this.iDenominatorCoefficient != 1.0 ? " x " + this.iDenominatorCoefficient : "");
    }

    public String toString() {
        return this.getName();
    }

    public double calculate(Peak[] aPeaks, double aIonTolerance, Mass aMassType) {
        double lResult = 0.0;
        double lNumeratorMass = 0.0;
        double lDenominatorMass = 0.0;
        Peak lNumeratorPeak = null;
        Peak lDenominatorPeak = null;
        if (aMassType == Mass.AVERAGE) {
            lNumeratorMass = this.iNumerator.getAverage();
            lDenominatorMass = this.iDenominator.getAverage();
        } else if (aMassType == Mass.MONOISOTOPIC) {
            lNumeratorMass = this.iNumerator.getMonoisotopic();
            lDenominatorMass = this.iDenominator.getMonoisotopic();
        }
        for (int i = 0; i < aPeaks.length; ++i) {
            Peak lPeak = aPeaks[i];
            if (Math.abs(lPeak.getMZ() - lNumeratorMass) < aIonTolerance) {
                lNumeratorPeak = lPeak;
            }
            if (Math.abs(lPeak.getMZ() - lDenominatorMass) < aIonTolerance) {
                lDenominatorPeak = lPeak;
            }
            if (lDenominatorPeak != null & lNumeratorPeak != null) break;
        }
        if (lNumeratorPeak == null) {
            lResult += NUMERATOR_NOT_FOUND;
        }
        if (lDenominatorPeak == null) {
            lResult += DENOMINATOR_NOT_FOUND;
        }
        if (lResult == 0.0) {
            lResult = lNumeratorPeak.getIntensity() * this.iNumeratorCoefficient / (lDenominatorPeak.getIntensity() * this.iDenominatorCoefficient);
            BigDecimal lBigDecimal = new BigDecimal(lResult);
            lBigDecimal = lBigDecimal.setScale(4, 0);
            lResult = lBigDecimal.doubleValue();
        }
        return lResult;
    }
}

