## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    library(ORFik)                        # This package
#    conf <- config.exper(experiment = "CHALMERS_Yeast", # Name
#                       assembly = "Yeast_SacCer3", # Reference folder
#                       type = c("RNA-seq")) # fastq and bam type

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  
#  info <- download.SRA.metadata("SRP012047", outdir = conf["fastq RNA-seq"])
#  # Let's take 2 first runs in this experiment:
#  info <- info[1:2,]
#  # 18 MB, ~ 40 sec download time ->
#  download.SRA(info, conf["fastq RNA-seq"], subset = 50000)
#  # 1.6 GB, ~ 100 sec download time (faster download) ->
#  # download.SRA(info, conf["fastq RNA-seq"])

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  organism <- info$ScientificName[1]
#  is_paired_end <- all(info$LibraryLayout == "PAIRED")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    annotation <- getGenomeAndAnnotation(
#                        organism = organism,
#                        output.dir = conf["ref"],
#                        assembly_type = "toplevel"
#                        )

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  index <- STAR.index(annotation)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  alignment <-
#    STAR.align.folder(conf["fastq RNA-seq"], conf["bam RNA-seq"], index,
#                      paired.end = is_paired_end,
#                      steps = "tr-ge", # (trim needed: adapters found, then genome)
#                      adapter.sequence = "auto",
#                      max.cpus = 30, trim.front = 3, min.length = 20)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  index <- STAR.index(annotation, max.ram = 20, SAsparse = 2)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  STAR.align.folder(conf["fastq RNA-seq"], conf["bam RNA-seq"], index,
#                      max.cpus = 12) # Reduce cores to 12 usually works for most systems

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  txdb_file <- paste0(annotation["gtf"], ".db") # Get txdb file, not raw gtf
#  fa <- annotation["genome"]
#  create.experiment(exper = "yeast_exp_RNA",
#                    dir = paste0(conf["bam RNA-seq"], "/aligned/"),
#                    txdb = txdb_file, fa = fa,
#                    organism = organism,
#                    viewTemplate = FALSE,
#                    pairedEndBam = is_paired_end # True/False per bam file
#                    )

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#  df <- read.experiment("yeast_exp_RNA")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    QCreport(df)

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    remove.experiments(df) # Remove loaded libraries
#    convertLibs(df, type = "ofst")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    remove.experiments(df)
#    convertLibs(df, type = "wig")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    remove.experiments(df)
#    outputLibs(df, type = "ofst")

## ----eval = FALSE, echo = TRUE, message = FALSE-------------------------------
#    mrna <- countTable(df, region = "mrna", type = "fpkm")
#    cds <- countTable(df, region = "cds", type = "fpkm")
#    ratio <- cds / mrna

