## ----style, echo=FALSE, results="asis", message=FALSE, warnings = FALSE-------
knitr::opts_chunk$set(tidy = FALSE,
                      warning = FALSE,
                      message = FALSE,fig.width=6, fig.height=6 )

## ----set size-----------------------------------------------------------------
knitr::opts_knit$set(width = 80)

## ----Install, eval=FALSE, echo=TRUE, include=TRUE-----------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("NoRCE")

## ----Load, eval=TRUE, echo=TRUE, include=TRUE---------------------------------
library(NoRCE)

## ----Load package, eval=TRUE, echo=TRUE, include=TRUE-------------------------
library(NoRCE)

## ---- Enrichment analysis based on gene neighbourhood when input set is consist of genes, eval=TRUE, echo = FALSE----
ncGO<-geneGOEnricher(gene = brain_disorder_ncRNA, org_assembly='hg19', near=TRUE, genetype = 'Ensembl_gene')


## ---- Intersection of the nearest genes of the input gene set and the potential target set is carries out for enrichment analysis, eval=TRUE----
mirGO<-mirnaGOEnricher(gene = brain_mirna, org_assembly='hg19', near=TRUE, target=TRUE)


## ---- Retrieve list of cell-line , eval=TRUE----------------------------------
a<-listTAD(TADName = tad_hg19)

## ---- Enrichment based on TAD cellline, eval=TRUE-----------------------------
mirGO<-mirnaGOEnricher(gene = brain_mirna, org_assembly='hg19', near=TRUE, isTADSearch = TRUE, TAD = tad_hg19)


## ---- Pathway enrichment based on the gen sets that falls into the TAD regions, eval=TRUE----
ncRNAPathway<-genePathwayEnricher(gene = brain_disorder_ncRNA, org_assembly='hg19', isTADSearch = TRUE,TAD = tad_hg19, genetype = 'Ensembl_gene')

## ----Custom correlation analysis, eval=TRUE, echo=TRUE------------------------
dataCor <- calculateCorr(exp1 =  mirna[,1:50], exp2 = mrna[,1:50])


