/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.io;

import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.biojava.utils.Constants;

public class LargeBuffer {
    private static final long PAGE_SIZE;
    private static final long PAGE_OVERLAP;
    private final long pos;
    private final long size;
    private final FileChannel channel;
    private final FileChannel.MapMode mode;
    private long position = 0L;
    private int lastBufferIndex = -1;
    private MappedByteBuffer lastBuffer = null;

    public LargeBuffer(FileChannel channel, FileChannel.MapMode mode, long pos, long size) throws IOException {
        this.channel = channel;
        this.mode = mode;
        this.pos = pos;
        this.size = size;
    }

    private MappedByteBuffer getBuffer(int index) throws IOException {
        if (index != this.lastBufferIndex) {
            System.out.println("Allocating page: " + index);
            long offset = PAGE_SIZE * (long)index;
            System.out.println("From: " + (this.pos + offset));
            System.out.println("Size: " + Math.min(this.size - offset, PAGE_SIZE + PAGE_OVERLAP));
            this.lastBuffer = this.channel.map(this.mode, this.pos + offset, Math.min(this.size - offset, PAGE_SIZE + PAGE_OVERLAP));
            this.lastBufferIndex = index;
            System.out.println("Done");
        }
        return this.lastBuffer;
    }

    public byte get(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.get(offset);
    }

    public byte get() throws IndexOutOfBoundsException, IOException {
        byte val = this.get(this.position);
        this.position += (long)Constants.BYTES_IN_BYTE;
        return val;
    }

    public void put(long pos, byte b) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.put(offset, b);
    }

    public void put(byte val) throws IndexOutOfBoundsException, IOException {
        this.put(this.position, val);
        this.position += (long)Constants.BYTES_IN_BYTE;
    }

    public char getChar(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.getChar(offset);
    }

    public char getChar() throws IndexOutOfBoundsException, IOException {
        char val = this.getChar(this.position);
        this.position += (long)Constants.BYTES_IN_CHAR;
        return val;
    }

    public void putChar(long pos, char c) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.putChar(offset, c);
    }

    public void putChar(char val) throws IndexOutOfBoundsException, IOException {
        this.putChar(this.position, val);
        this.position += (long)Constants.BYTES_IN_CHAR;
    }

    public double getDouble(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.getDouble(offset);
    }

    public double getDouble() throws IndexOutOfBoundsException, IOException {
        double val = this.getDouble(this.position);
        this.position += (long)Constants.BYTES_IN_DOUBLE;
        return val;
    }

    public void putDouble(long pos, double d) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.putDouble(offset, d);
    }

    public void putDouble(double val) throws IndexOutOfBoundsException, IOException {
        this.putDouble(this.position, val);
        this.position += (long)Constants.BYTES_IN_DOUBLE;
    }

    public float getFloat(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.getFloat(offset);
    }

    public float getFloat() throws IndexOutOfBoundsException, IOException {
        float val = this.getFloat(this.position);
        this.position += (long)Constants.BYTES_IN_FLOAT;
        return val;
    }

    public void putFloat(long pos, float f) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.putFloat(offset, f);
    }

    public void putFloat(float val) throws IndexOutOfBoundsException, IOException {
        this.putFloat(this.position, val);
        this.position += (long)Constants.BYTES_IN_FLOAT;
    }

    public int getInt(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.getInt(offset);
    }

    public int getInt() throws IndexOutOfBoundsException, IOException {
        int val = this.getInt(this.position);
        this.position += (long)Constants.BYTES_IN_INT;
        return val;
    }

    public void putInt(long pos, int i) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.putInt(offset, i);
    }

    public void putInt(int val) throws IndexOutOfBoundsException, IOException {
        this.putInt(this.position, val);
        this.position += (long)Constants.BYTES_IN_INT;
    }

    public long getLong(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.getLong(offset);
    }

    public long getLong() throws IndexOutOfBoundsException, IOException {
        long val = this.getLong(this.position);
        this.position += (long)Constants.BYTES_IN_LONG;
        return val;
    }

    public void putLong(long pos, long l) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.putLong(offset, l);
    }

    public void putLong(long val) throws IndexOutOfBoundsException, IOException {
        this.putLong(this.position, val);
        this.position += (long)Constants.BYTES_IN_LONG;
    }

    public short getShort(long pos) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        return buffer.getShort(offset);
    }

    public short getShort() throws IndexOutOfBoundsException, IOException {
        short val = this.getShort(this.position);
        this.position += (long)Constants.BYTES_IN_SHORT;
        return val;
    }

    public void putShort(long pos, short s) throws IndexOutOfBoundsException, IOException {
        int offset = this.getOffset(pos);
        int index = this.getIndex(pos);
        MappedByteBuffer buffer = this.getBuffer(index);
        buffer.putShort(offset, s);
    }

    public void putShort(short val) throws IndexOutOfBoundsException, IOException {
        this.putShort(this.position, val);
        this.position += (long)Constants.BYTES_IN_SHORT;
    }

    public long position() {
        return this.position;
    }

    public void position(long pos) {
        this.position = pos;
    }

    private int getOffset(long pos) throws IndexOutOfBoundsException {
        if (pos > this.size) {
            throw new IndexOutOfBoundsException();
        }
        return (int)(pos % PAGE_SIZE);
    }

    private int getIndex(long pos) {
        return (int)(pos / PAGE_SIZE);
    }

    public void force() {
    }

    static {
        PAGE_OVERLAP = Constants.BYTES_IN_LONG;
        PAGE_SIZE = 0xFFFFFFFL - PAGE_OVERLAP;
    }
}

