/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.taxa;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.biojava.bio.taxa.Taxon;
import org.biojava.bio.taxa.TaxonFactory;
import org.biojava.bio.taxa.WeakTaxon;
import org.biojava.utils.SmallSet;

public class WeakTaxonFactory
implements TaxonFactory {
    public static final WeakTaxonFactory GLOBAL = new WeakTaxonFactory("GLOBAL");
    private final Taxon root;
    private final String name;
    private final Map taxonBySciName = new WeakHashMap();

    public WeakTaxonFactory(String name) {
        this.name = name;
        this.root = this.createTaxon("ROOT", "");
    }

    public Taxon getRoot() {
        return this.root;
    }

    public String getName() {
        return this.name;
    }

    public Taxon importTaxon(Taxon taxon) {
        WeakTaxon can = this.canonicalize(taxon);
        if (can == null) {
            can = new WeakTaxon(taxon.getScientificName(), taxon.getCommonName());
            Iterator i = taxon.getChildren().iterator();
            while (i.hasNext()) {
                Taxon child = (Taxon)i.next();
                this.addChild(can, child);
            }
            return can;
        }
        return can;
    }

    public Taxon createTaxon(String scientificName, String commonName) {
        WeakTaxon taxon = new WeakTaxon(scientificName, commonName);
        this.taxonBySciName.put(scientificName, new WeakReference<WeakTaxon>(taxon));
        return taxon;
    }

    public Taxon addChild(Taxon parent, Taxon child) {
        WeakTaxon sparent = (WeakTaxon)this.importTaxon(parent);
        WeakTaxon schild = (WeakTaxon)this.importTaxon(child);
        Set children = sparent.getChildrenRaw();
        if (children == null) {
            children = new SmallSet();
            sparent.setChildrenRaw(children);
        }
        children.add(schild);
        schild.setParent(sparent);
        return schild;
    }

    public Taxon removeChild(Taxon parent, Taxon child) {
        WeakTaxon sparent = this.canonicalize(parent);
        WeakTaxon schild = this.canonicalize(child);
        if (sparent == null) {
            throw new IllegalArgumentException("Don't know about parent taxon");
        }
        Set children = sparent.getChildrenRaw();
        if (schild != null && children != null && children.remove(schild)) {
            return schild;
        }
        return null;
    }

    public Taxon search(Object id) {
        WeakReference wr = (WeakReference)this.taxonBySciName.get(id);
        if (wr != null) {
            return (Taxon)wr.get();
        }
        return null;
    }

    private WeakTaxon canonicalize(Taxon taxon) {
        return (WeakTaxon)this.search(taxon.getScientificName());
    }
}

