/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.CyAttributesUtils;
import cytoscape.visual.mappings.ObjectMapping;
import giny.model.GraphObject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingKeyFactory {
    public static Set<Object> getKeySet(String attrName, CyAttributes attrs, ObjectMapping mapping, boolean isNode) {
        if (attrName.equals("ID")) {
            return MappingKeyFactory.loadID(isNode);
        }
        Map id2AttrValMap = CyAttributesUtils.getAttribute(attrName, attrs);
        if (id2AttrValMap == null || id2AttrValMap.size() == 0) {
            return new TreeSet<Object>();
        }
        List<Class<?>> acceptedClasses = Arrays.asList(mapping.getAcceptedDataClasses());
        Class mapAttrClass = CyAttributesUtils.getClass(attrName, attrs);
        if (mapAttrClass == null || !acceptedClasses.contains(mapAttrClass)) {
            return new TreeSet<Object>();
        }
        return MappingKeyFactory.loadKeySet(id2AttrValMap);
    }

    private static Set<Object> loadID(boolean isNode) {
        TreeSet<Object> ids = new TreeSet<Object>();
        List obj = isNode ? Cytoscape.getCurrentNetworkView().getNetwork().nodesList() : Cytoscape.getCurrentNetworkView().getNetwork().edgesList();
        for (GraphObject o : obj) {
            ids.add(o.getIdentifier());
        }
        return ids;
    }

    private static Set<Object> loadKeySet(Map<String, Object> id2AttrMap) {
        TreeSet<Object> mappedKeys = new TreeSet<Object>();
        for (Object attrValue : id2AttrMap.values()) {
            if (attrValue instanceof List) {
                List list = (List)attrValue;
                for (int i = 0; i < list.size(); ++i) {
                    Object vo = list.get(i);
                    if (mappedKeys.contains(vo)) continue;
                    mappedKeys.add(vo);
                }
                continue;
            }
            if (mappedKeys.contains(attrValue)) continue;
            mappedKeys.add(attrValue);
        }
        return mappedKeys;
    }
}

