/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual;

import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.attr.MultiHashMapDefinition;
import cytoscape.logger.CyLogger;
import cytoscape.view.CyNetworkView;
import cytoscape.visual.CalculatorCatalog;
import cytoscape.visual.CalculatorCatalogFactory;
import cytoscape.visual.EdgeAppearance;
import cytoscape.visual.EdgeAppearanceCalculator;
import cytoscape.visual.GlobalAppearance;
import cytoscape.visual.GlobalAppearanceCalculator;
import cytoscape.visual.NodeAppearance;
import cytoscape.visual.NodeAppearanceCalculator;
import cytoscape.visual.SubjectBase;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.VisualStyle;
import cytoscape.visual.customgraphic.CustomGraphicsManager;
import cytoscape.visual.mappings.RangeValueCalculatorFactory;
import cytoscape.visual.mappings.RangeValueCalculatorFactoryImpl;
import cytoscape.visual.mappings.rangecalculators.ColorRangeValueCalculator;
import cytoscape.visual.mappings.rangecalculators.CustomGraphicsRangeValueCalculator;
import cytoscape.visual.mappings.rangecalculators.DoubleRangeValueCalculator;
import cytoscape.visual.mappings.rangecalculators.FloatRangeValueCalculator;
import cytoscape.visual.mappings.rangecalculators.NodeShapeRangeValueCalculator;
import cytoscape.visual.mappings.rangecalculators.StringRangeValueCalculator;
import ding.view.DGraphView;
import ding.view.DingCanvas;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualMappingManager
extends SubjectBase {
    private CalculatorCatalog catalog;
    private CyNetworkView networkView;
    private VisualStyle activeVS;
    private final NodeAppearance myNodeApp = new NodeAppearance();
    private final EdgeAppearance myEdgeApp = new EdgeAppearance();
    private final GlobalAppearance myGlobalApp = new GlobalAppearance();
    private static final String DEF_STYLE_NAME = "default";
    private final CustomGraphicsManager pool;
    private final RangeValueCalculatorFactory rvcFactory;

    public VisualMappingManager(CyNetworkView networkView) {
        VisualStyle vs;
        this.networkView = networkView;
        this.pool = new CustomGraphicsManager();
        this.rvcFactory = new RangeValueCalculatorFactoryImpl();
        this.registerDefaultRangeValueCalculators();
        this.loadCalculatorCatalog();
        String defStyle = CytoscapeInit.getProperties().getProperty("defaultVisualStyle");
        if (defStyle == null) {
            defStyle = DEF_STYLE_NAME;
        }
        if ((vs = this.catalog.getVisualStyle(defStyle)) == null) {
            vs = this.catalog.getVisualStyle(DEF_STYLE_NAME);
        }
        this.setVisualStyle(vs);
    }

    public void loadCalculatorCatalog() {
        this.loadCalculatorCatalog(null);
    }

    public void loadCalculatorCatalog(String vizmapLocation) {
        if (this.catalog == null) {
            this.catalog = CalculatorCatalogFactory.loadCalculatorCatalog();
        } else if (vizmapLocation != null) {
            this.catalog = CalculatorCatalogFactory.loadCalculatorCatalog();
        }
    }

    public void setNetworkView(CyNetworkView new_view) {
        this.networkView = new_view;
    }

    public CyNetworkView getNetworkView() {
        return this.networkView;
    }

    public CyNetwork getNetwork() {
        return this.networkView.getNetwork();
    }

    public CalculatorCatalog getCalculatorCatalog() {
        return this.catalog;
    }

    public VisualStyle getVisualStyle() {
        return this.activeVS;
    }

    public VisualStyle setVisualStyle(VisualStyle vs) {
        if (vs != null && vs != this.activeVS) {
            VisualStyle tmp = this.activeVS;
            this.activeVS = vs;
            this.fireStateChanged();
            return tmp;
        }
        return this.activeVS;
    }

    public VisualStyle setVisualStyle(String newVSName) {
        VisualStyle vs = this.catalog.getVisualStyle(newVSName);
        if (vs != null) {
            return this.setVisualStyle(vs);
        }
        return this.activeVS;
    }

    public void applyNodeAppearances() {
        this.applyNodeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyNodeAppearances(CyNetwork network, CyNetworkView network_view) {
        NodeAppearanceCalculator nodeAppearanceCalculator = this.activeVS.getNodeAppearanceCalculator();
        List<VisualPropertyType> bypassedVPs = this.getBypassedVPs("NODE", Cytoscape.getNodeAttributes());
        Iterator itr = network_view.getNodeViewsIterator();
        while (itr.hasNext()) {
            NodeView nodeView = (NodeView)itr.next();
            Node node = nodeView.getNode();
            nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network, bypassedVPs);
            this.myNodeApp.applyAppearance(nodeView, this.activeVS.getDependency());
        }
    }

    public void applyEdgeAppearances() {
        this.applyEdgeAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyEdgeAppearances(CyNetwork network, CyNetworkView network_view) {
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.activeVS.getEdgeAppearanceCalculator();
        List<VisualPropertyType> bypassedVPs = this.getBypassedVPs("EDGE", Cytoscape.getEdgeAttributes());
        Iterator i = network_view.getEdgeViewsIterator();
        while (i.hasNext()) {
            EdgeView edgeView = (EdgeView)i.next();
            if (edgeView == null) continue;
            edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edgeView.getEdge(), network, bypassedVPs);
            this.myEdgeApp.applyAppearance(edgeView, this.activeVS.getDependency());
        }
    }

    private List<VisualPropertyType> getBypassedVPs(String prefix, CyAttributes attrs) {
        MultiHashMapDefinition mhmd = attrs.getMultiHashMapDefinition();
        ArrayList<VisualPropertyType> bypassAttrs = new ArrayList<VisualPropertyType>();
        for (VisualPropertyType vp : VisualPropertyType.values()) {
            if (!vp.toString().startsWith(prefix) || mhmd.getAttributeValueType(vp.getBypassAttrName()) < 0) continue;
            bypassAttrs.add(vp);
        }
        return bypassAttrs;
    }

    public void applyGlobalAppearances() {
        this.applyGlobalAppearances(this.getNetwork(), this.getNetworkView());
    }

    public void applyGlobalAppearances(CyNetwork network, CyNetworkView network_view) {
        GlobalAppearanceCalculator globalAppearanceCalculator = this.activeVS.getGlobalAppearanceCalculator();
        globalAppearanceCalculator.calculateGlobalAppearance(this.myGlobalApp, network);
        if (network_view instanceof DGraphView) {
            DingCanvas backgroundCanvas = ((DGraphView)((Object)network_view)).getCanvas(DGraphView.Canvas.BACKGROUND_CANVAS);
            backgroundCanvas.setBackground(this.myGlobalApp.getBackgroundColor());
        } else {
            CyLogger.getLogger().info("VisualMappingManager.applyGlobalAppearances() - DGraphView not found!");
            network_view.setBackgroundPaint(this.myGlobalApp.getBackgroundColor());
        }
        Iterator nodeIt = network.nodesIterator();
        while (nodeIt.hasNext()) {
            network_view.getNodeView((CyNode)nodeIt.next()).setSelectedPaint(this.myGlobalApp.getNodeSelectionColor());
        }
        Iterator edgeIt = network.edgesIterator();
        while (edgeIt.hasNext()) {
            network_view.getEdgeView((CyEdge)edgeIt.next()).setSelectedPaint(this.myGlobalApp.getEdgeSelectionColor());
        }
    }

    public void applyAppearances() {
        this.applyNodeAppearances();
        this.applyEdgeAppearances();
        this.applyGlobalAppearances();
    }

    public void vizmapNode(NodeView nodeView, CyNetworkView network_view) {
        CyNode node = (CyNode)nodeView.getNode();
        List<VisualPropertyType> bypassedVPs = this.getBypassedVPs("NODE", Cytoscape.getNodeAttributes());
        NodeAppearanceCalculator nodeAppearanceCalculator = this.activeVS.getNodeAppearanceCalculator();
        nodeAppearanceCalculator.calculateNodeAppearance(this.myNodeApp, node, network_view.getNetwork(), bypassedVPs);
        this.myNodeApp.applyAppearance(nodeView, this.activeVS.getDependency());
    }

    public void vizmapEdge(EdgeView edgeView, CyNetworkView network_view) {
        CyEdge edge = (CyEdge)edgeView.getEdge();
        List<VisualPropertyType> bypassedVPs = this.getBypassedVPs("EDGE", Cytoscape.getEdgeAttributes());
        EdgeAppearanceCalculator edgeAppearanceCalculator = this.activeVS.getEdgeAppearanceCalculator();
        edgeAppearanceCalculator.calculateEdgeAppearance(this.myEdgeApp, edge, network_view.getNetwork(), bypassedVPs);
        this.myEdgeApp.applyAppearance(edgeView, this.activeVS.getDependency());
    }

    public CustomGraphicsManager getCustomGraphicsManager() {
        return this.pool;
    }

    public RangeValueCalculatorFactory getRangeValueCalculatorFactory() {
        return this.rvcFactory;
    }

    private void registerDefaultRangeValueCalculators() {
        this.rvcFactory.registerRVC(new StringRangeValueCalculator());
        this.rvcFactory.registerRVC(new DoubleRangeValueCalculator());
        this.rvcFactory.registerRVC(new ColorRangeValueCalculator());
        this.rvcFactory.registerRVC(new NodeShapeRangeValueCalculator());
        this.rvcFactory.registerRVC(new CustomGraphicsRangeValueCalculator());
        this.rvcFactory.registerRVC(new FloatRangeValueCalculator());
    }
}

