/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util.swing;

import cytoscape.Cytoscape;
import cytoscape.logger.CyLogger;
import cytoscape.util.OpenBrowser;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.layout.GroupLayout;

public class AboutDialog
extends JDialog
implements HyperlinkListener {
    private static final AboutDialog about;
    private static CyLogger logger;
    private JEditorPane mainEditorPane;
    private JScrollPane mainScrollPane;
    private JLabel titleLabel;
    private JPanel titlePanel;
    private JPanel mainPanel;

    public static void showDialog(String title, Icon icon, String description) {
        AboutDialog.about.titleLabel.setText(title);
        AboutDialog.about.titleLabel.setIcon(icon);
        URL target = null;
        AboutDialog.about.mainEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        try {
            target = new URL(description);
        }
        catch (MalformedURLException e) {
            AboutDialog.about.mainEditorPane.setContentType("text/html");
            AboutDialog.about.mainEditorPane.setText(description);
            about.repaint();
            about.setVisible(true);
            return;
        }
        try {
            AboutDialog.about.mainEditorPane.setPage(target);
            about.pack();
            about.repaint();
            about.setVisible(true);
        }
        catch (IOException e) {
            AboutDialog.about.mainEditorPane.setText("Could not connect to " + target.toString());
            logger.warn("Could not connect to " + target.toString(), e);
            about.pack();
            about.repaint();
            about.setVisible(true);
        }
    }

    public AboutDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.mainEditorPane.setEditable(false);
        this.mainEditorPane.addHyperlinkListener(this);
        this.setLocationRelativeTo(Cytoscape.getDesktop());
        this.setAlwaysOnTop(true);
    }

    public AboutDialog(Frame parent, boolean modal, String title, Icon icon, URL contentURL) {
        super(parent, modal);
        this.initComponents();
        this.mainEditorPane.setContentType("text/html");
    }

    private void initComponents() {
        this.titlePanel = new JPanel();
        this.titleLabel = new JLabel();
        this.mainPanel = new JPanel();
        this.mainScrollPane = new JScrollPane();
        this.mainEditorPane = new JEditorPane();
        this.setDefaultCloseOperation(2);
        this.setTitle("About");
        this.setAlwaysOnTop(true);
        this.titlePanel.setBackground(new Color(255, 255, 255));
        this.titleLabel.setFont(new Font("SansSerif", 0, 18));
        this.titleLabel.setText("Client Name Here");
        GroupLayout titlePanelLayout = new GroupLayout(this.titlePanel);
        this.titlePanel.setLayout(titlePanelLayout);
        titlePanelLayout.setHorizontalGroup(titlePanelLayout.createParallelGroup(1).add(titlePanelLayout.createSequentialGroup().addContainerGap().add(this.titleLabel, -1, 339, Short.MAX_VALUE).addContainerGap()));
        titlePanelLayout.setVerticalGroup(titlePanelLayout.createParallelGroup(1).add(titlePanelLayout.createSequentialGroup().addContainerGap().add(this.titleLabel, -1, 32, Short.MAX_VALUE).addContainerGap()));
        this.mainPanel.setBackground(new Color(255, 255, 255));
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setFont(new Font("SansSerif", 0, 12));
        this.mainEditorPane.setEditable(false);
        this.mainScrollPane.setViewportView(this.mainEditorPane);
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().addContainerGap().add(this.mainScrollPane).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().addContainerGap().add(this.mainScrollPane, -1, 215, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(this.titlePanel, -1, -1, Short.MAX_VALUE).add(2, this.mainPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(this.titlePanel, -2, -1, -2).addPreferredGap(0).add(this.mainPanel, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        String url = e.getURL().toString();
        try {
            OpenBrowser.openURL(url);
        }
        catch (Exception err) {
            logger.warn("Unable to open browser for " + url.toString(), err);
        }
    }

    static {
        logger = CyLogger.getLogger(AboutDialog.class);
        about = new AboutDialog((Frame)Cytoscape.getDesktop(), true);
    }
}

