/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.task.ui;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class StringUtils {
    public static final String NOT_AVAILABLE_STR = "N/A";
    public static final int STR_LENGTH = 60;

    public static String getTimeString(long time) {
        if (time < 0L) {
            return NOT_AVAILABLE_STR;
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTimeInMillis(time);
        SimpleDateFormat dateFormat = calendar.get(10) >= 1 ? new SimpleDateFormat("HH:mm:ss") : new SimpleDateFormat("mm:ss");
        dateFormat.setCalendar(calendar);
        return dateFormat.format(calendar.getTime());
    }

    public static String truncateOrPadString(String str) {
        StringBuffer temp = str == null ? new StringBuffer() : new StringBuffer(str);
        int diff = 60 - temp.length();
        if (diff > 0) {
            for (int i = 0; i < diff; ++i) {
                temp.append(" ");
            }
            return temp.toString();
        }
        return new String(temp.substring(0, 60) + "...");
    }
}

