/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.logger.CyLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.equations.EqnCompiler;
import org.cytoscape.equations.Equation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqnAttrTracker {
    private CyLogger logger = CyLogger.getLogger(EqnAttrTracker.class);
    private List<AttrInfo> nodeAttrs = new ArrayList<AttrInfo>();
    private List<AttrInfo> edgeAttrs = new ArrayList<AttrInfo>();
    private List<AttrInfo> networkAttrs = new ArrayList<AttrInfo>();

    void reset() {
        this.nodeAttrs.clear();
        this.edgeAttrs.clear();
        this.networkAttrs.clear();
    }

    void recordEquation(CyAttributes attribs, String id, String attrName, String equation, Class returnType) {
        if (attribs == AttrClass.NODES.getAttribs()) {
            this.nodeAttrs.add(new AttrInfo(id, attrName, equation, returnType));
        } else if (attribs == AttrClass.EDGES.getAttribs()) {
            this.edgeAttrs.add(new AttrInfo(id, attrName, equation, returnType));
        } else if (attribs == AttrClass.NETWORKS.getAttribs()) {
            this.networkAttrs.add(new AttrInfo(id, attrName, equation, returnType));
        } else {
            throw new IllegalArgumentException("unkown CyAttributes!");
        }
        if (returnType == Double.class) {
            EqnAttrTracker.registerFloat(attribs, id, attrName);
        } else if (returnType == Long.class) {
            EqnAttrTracker.registerInteger(attribs, id, attrName);
        } else if (returnType == String.class) {
            EqnAttrTracker.registerString(attribs, id, attrName);
        } else if (returnType == Boolean.class) {
            EqnAttrTracker.registerBoolean(attribs, id, attrName);
        } else if (returnType == List.class) {
            EqnAttrTracker.registerList(attribs, id, attrName);
        } else {
            throw new IllegalArgumentException("unknown retuyrn type: " + returnType + "!");
        }
    }

    void addAllEquations() {
        this.addEquations(AttrClass.NODES.getAttribs(), this.nodeAttrs);
        this.addEquations(AttrClass.EDGES.getAttribs(), this.edgeAttrs);
        this.addEquations(AttrClass.NETWORKS.getAttribs(), this.networkAttrs);
    }

    private void addEquations(CyAttributes attribs, List<AttrInfo> attrInfos) {
        EqnCompiler compiler = new EqnCompiler();
        String[] allAttribNames = attribs.getAttributeNames();
        Class[] allTypes = new Class[allAttribNames.length];
        HashMap<String, Class> attribNameToTypeMap = new HashMap<String, Class>();
        boolean index = false;
        for (String attribName : allAttribNames) {
            byte type = attribs.getType(attribName);
            Class eqnType = EqnAttrTracker.mapCytoscapeAttribTypeToEqnType(type);
            if (eqnType == null) continue;
            attribNameToTypeMap.put(attribName, eqnType);
        }
        for (AttrInfo attrInfo : attrInfos) {
            attribNameToTypeMap.remove(attrInfo.getAttrName());
            if (compiler.compile(attrInfo.getEquation(), attribNameToTypeMap)) {
                attribs.setAttribute(attrInfo.getID(), attrInfo.getAttrName(), compiler.getEquation());
            } else {
                String errorMessage = compiler.getLastErrorMsg();
                this.logger.warn("bad equation on import: " + errorMessage);
                Equation errorEquation = Equation.getErrorEquation(attrInfo.getEquation(), attrInfo.getReturnType(), errorMessage);
                attribs.setAttribute(attrInfo.getID(), attrInfo.getAttrName(), errorEquation);
            }
            attribNameToTypeMap.put(attrInfo.getAttrName(), attrInfo.getReturnType());
        }
    }

    private static Class mapCytoscapeAttribTypeToEqnType(byte attribType) {
        switch (attribType) {
            case 1: {
                return Boolean.class;
            }
            case 3: {
                return Long.class;
            }
            case 2: {
                return Double.class;
            }
            case 4: {
                return String.class;
            }
            case -2: {
                return List.class;
            }
        }
        return null;
    }

    private static void registerFloat(CyAttributes attrs, String id, String attrName) {
        attrs.setAttribute(id, attrName, 0.0);
        attrs.deleteAttribute(id, attrName);
    }

    private static void registerString(CyAttributes attrs, String id, String attrName) {
        attrs.setAttribute(id, attrName, "");
        attrs.deleteAttribute(id, attrName);
    }

    private static void registerInteger(CyAttributes attrs, String id, String attrName) {
        attrs.setAttribute(id, attrName, 0);
        attrs.deleteAttribute(id, attrName);
    }

    private static void registerBoolean(CyAttributes attrs, String id, String attrName) {
        attrs.setAttribute(id, attrName, true);
        attrs.deleteAttribute(id, attrName);
    }

    private static void registerList(CyAttributes attrs, String id, String attrName) {
        attrs.setListAttribute(id, attrName, new ArrayList());
        attrs.deleteAttribute(id, attrName);
    }

    private static class AttrInfo {
        private String id;
        private String attrName;
        private String equation;
        private Class returnType;

        AttrInfo(String id, String attrName, String equation, Class returnType) {
            this.id = id;
            this.attrName = attrName;
            this.equation = equation;
            this.returnType = returnType;
        }

        String getID() {
            return this.id;
        }

        String getAttrName() {
            return this.attrName;
        }

        String getEquation() {
            return this.equation;
        }

        Class getReturnType() {
            return this.returnType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AttrClass {
        NODES(Cytoscape.getNodeAttributes()),
        EDGES(Cytoscape.getEdgeAttributes()),
        NETWORKS(Cytoscape.getNetworkAttributes());

        private CyAttributes attribs;

        private AttrClass(CyAttributes attribs) {
            this.attribs = attribs;
        }

        CyAttributes getAttribs() {
            return this.attribs;
        }
    }
}

