/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import giny.model.GraphPerspective;
import giny.model.Node;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.NodeView;
import java.util.HashSet;
import java.util.Iterator;

public class GinyUtils {
    public static void hideSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        for (NodeView nview : view.getSelectedNodes()) {
            view.hideGraphObject(nview);
        }
        view.updateView();
    }

    public static void unHideSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        for (NodeView nview : view.getSelectedNodes()) {
            view.showGraphObject(nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true, true);
                for (int j = 0; j < edges.length; ++j) {
                    view.showGraphObject(view.getEdgeView(edges[j]));
                }
            }
        }
        view.updateView();
    }

    public static void unHideAll(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            view.showGraphObject(nview);
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            view.showGraphObject(eview);
        }
        view.updateView();
    }

    public static void unHideNodesAndInterconnectingEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            Node n = nview.getNode();
            view.showGraphObject(nview);
            int[] na = view.getGraphPerspective().neighborsArray(nview.getGraphPerspectiveIndex());
            for (int i2 = 0; i2 < na.length; ++i2) {
                int[] edges = view.getGraphPerspective().getEdgeIndicesArray(nview.getGraphPerspectiveIndex(), na[i2], true);
                if (edges == null) continue;
                for (int j = 0; j < edges.length; ++j) {
                    EdgeView ev = view.getEdgeView(edges[j]);
                    view.showGraphObject(ev);
                }
            }
        }
        view.updateView();
    }

    public static void hideSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getSelectedEdges()) {
            view.hideGraphObject(eview);
        }
        view.updateView();
    }

    public static void unHideSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getSelectedEdges()) {
            view.showGraphObject(eview);
        }
        view.updateView();
    }

    public static void invertSelectedNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview;
            nview.setSelected(!(nview = (NodeView)i.next()).isSelected());
        }
        view.updateView();
    }

    public static void invertSelectedEdges(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getEdgeViewsList().iterator();
        while (i.hasNext()) {
            EdgeView eview;
            eview.setSelected(!(eview = (EdgeView)i.next()).isSelected());
        }
        view.updateView();
    }

    public static void selectFirstNeighbors(GraphView view) {
        if (view == null) {
            return;
        }
        GraphPerspective graphPerspective = view.getGraphPerspective();
        HashSet<NodeView> nodeViewsToSelect = new HashSet<NodeView>();
        for (NodeView nview : view.getSelectedNodes()) {
            Node n = nview.getNode();
            for (Node neib : graphPerspective.neighborsList(n)) {
                NodeView neibview = view.getNodeView(neib);
                nodeViewsToSelect.add(neibview);
            }
        }
        for (NodeView nview : nodeViewsToSelect) {
            nview.setSelected(true);
        }
        view.updateView();
    }

    public static void selectAllNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            nview.setSelected(true);
        }
        view.updateView();
    }

    public static void deselectAllNodes(GraphView view) {
        if (view == null) {
            return;
        }
        Iterator i = view.getNodeViewsIterator();
        while (i.hasNext()) {
            NodeView nview = (NodeView)i.next();
            nview.setSelected(false);
        }
        view.updateView();
    }

    public static void selectAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            eview.setSelected(true);
        }
        view.updateView();
    }

    public static void deselectAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            eview.setSelected(false);
        }
        view.updateView();
    }

    public static void hideAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            view.hideGraphObject(eview);
        }
        view.updateView();
    }

    public static void unHideAllEdges(GraphView view) {
        if (view == null) {
            return;
        }
        for (EdgeView eview : view.getEdgeViewsList()) {
            view.showGraphObject(eview);
        }
        view.updateView();
    }
}

