/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glf.demos;

import com.sun.glf.CompositeRenderer;
import com.sun.glf.Composition;
import com.sun.glf.FillRenderer;
import com.sun.glf.Layer;
import com.sun.glf.LayerComposition;
import com.sun.glf.Position;
import com.sun.glf.Renderer;
import com.sun.glf.ShapeLayer;
import com.sun.glf.StrokeRenderer;
import com.sun.glf.TextAlignment;
import com.sun.glf.TextLayer;
import com.sun.glf.goodies.GaussianKernel;
import com.sun.glf.util.CompositionFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.ConvolveOp;
import java.util.Vector;

public class GLFWebDemoOne
implements CompositionFactory {
    Dimension size = new Dimension(1024, 768);
    int numberOfWavelets = 5;
    int numberOfWaves = 4;
    int topTextDepth = 5;
    float waveOverlapRatio = 0.33333334f;
    Color waveTopColor = new Color(76, 163, 232);
    Color waveBottomColor = new Color(0, 135, 64);
    Color backgroundTopColor = new Color(236, 182, 0);
    Color backgroundBottomColor = new Color(224, 204, 149);
    Color topTextShadowTopColor = new Color(236, 133, 0, 0);
    Color topTextShadowBottomColor = new Color(236, 133, 0);
    int textWaveIndex = 2;
    float waveStrokeWidth = 5.0f;
    String topText = "Hot &";
    String bottomText = "Cool";
    Font textFont = new Font("serif", 0, 300);
    Color textColor = Color.black;
    int shadowBlurRadius = 12;

    public int getShadowBlurRadius() {
        return this.shadowBlurRadius;
    }

    public void setShadowBlurRadius(int n) {
        this.shadowBlurRadius = n;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        this.size = dimension;
    }

    public int getNumberOfWavelets() {
        return this.numberOfWavelets;
    }

    public void setNumberOfWavelets(int n) {
        this.numberOfWavelets = n;
    }

    public int getNumberOfWaves() {
        return this.numberOfWaves;
    }

    public void setNumberOfWaves(int n) {
        this.numberOfWaves = n;
    }

    public int getTopTextDepth() {
        return this.topTextDepth;
    }

    public void setTopTextDepth(int n) {
        this.topTextDepth = n;
    }

    public float getWaveOverlapRatio() {
        return this.waveOverlapRatio;
    }

    public void setWaveOverlapRatio(float f) {
        this.waveOverlapRatio = f;
    }

    public Color getWaveTopColor() {
        return this.waveTopColor;
    }

    public void setWaveTopColor(Color color) {
        this.waveTopColor = color;
    }

    public Color getWaveBottomColor() {
        return this.waveBottomColor;
    }

    public void setWaveBottomColor(Color color) {
        this.waveBottomColor = color;
    }

    public Color getBackgroundTopColor() {
        return this.backgroundTopColor;
    }

    public void setBackgroundTopColor(Color color) {
        this.backgroundTopColor = color;
    }

    public Color getBackgroundBottomColor() {
        return this.backgroundBottomColor;
    }

    public void setBackgroundBottomColor(Color color) {
        this.backgroundBottomColor = color;
    }

    public Color getTopTextShadowTopColor() {
        return this.topTextShadowTopColor;
    }

    public void setTopTextShadowTopColor(Color color) {
        this.topTextShadowTopColor = color;
    }

    public Color getTopTextShadowBottomColor() {
        return this.topTextShadowBottomColor;
    }

    public void setTopTextShadowBottomColor(Color color) {
        this.topTextShadowBottomColor = color;
    }

    public int getTextWaveIndex() {
        return this.textWaveIndex;
    }

    public void setTextWaveIndex(int n) {
        this.textWaveIndex = n;
    }

    public float getWaveStrokeWidth() {
        return this.waveStrokeWidth;
    }

    public void setWaveStrokeWidth(float f) {
        this.waveStrokeWidth = f;
    }

    public String getTopText() {
        return this.topText;
    }

    public void setTopText(String string) {
        this.topText = string;
    }

    public String getBottomText() {
        return this.bottomText;
    }

    public void setBottomText(String string) {
        this.bottomText = string;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font font) {
        this.textFont = font;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    private Shape createWave() {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(0.0f, 0.0f);
        generalPath.quadTo(2.0f, 0.0f, 3.0f, 2.0f);
        generalPath.quadTo(4.0f, 4.0f, 6.0f, 4.0f);
        generalPath.quadTo(8.0f, 4.0f, 9.0f, 2.0f);
        generalPath.quadTo(10.0f, 0.0f, 12.0f, 0.0f);
        if (this.numberOfWaves < 1) {
            throw new IllegalArgumentException();
        }
        float f = (float)this.size.height / ((1.0f - this.waveOverlapRatio) * 2.0f * (float)this.numberOfWaves);
        float f2 = f / 3.0f;
        AffineTransform affineTransform = AffineTransform.getScaleInstance(1.0, f2 / 4.0f);
        Shape shape = affineTransform.createTransformedShape(generalPath);
        Rectangle rectangle = shape.getBounds();
        GeneralPath generalPath2 = new GeneralPath();
        AffineTransform affineTransform2 = new AffineTransform();
        for (int i = 1; i <= this.numberOfWavelets; ++i) {
            generalPath2.append(affineTransform2.createTransformedShape(shape), false);
            affineTransform2.translate(rectangle.width, 0.0);
        }
        generalPath2.lineTo(rectangle.width * this.numberOfWavelets, f);
        generalPath2.lineTo(0.0f, f);
        generalPath2.lineTo(0.0f, 0.0f);
        Rectangle rectangle2 = generalPath2.getBounds();
        rectangle2.width = (int)((float)rectangle2.width - 2.0f * this.waveStrokeWidth);
        float f3 = (float)this.size.width / (float)rectangle2.width;
        affineTransform2.setToTranslation(-this.waveStrokeWidth, 0.0);
        affineTransform2.scale(f3, 1.0);
        return affineTransform2.createTransformedShape(generalPath2);
    }

    public Composition build() {
        Object[] objectArray;
        Object object;
        LayerComposition layerComposition = new LayerComposition(this.size);
        Vector<Object> vector = new Vector<Object>();
        Rectangle rectangle = new Rectangle(0, 0, this.size.width, this.size.height / 2);
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, this.backgroundTopColor, 0.0f, rectangle.height, this.backgroundBottomColor);
        ShapeLayer shapeLayer = new ShapeLayer(layerComposition, rectangle, new FillRenderer(gradientPaint));
        vector.addElement(shapeLayer);
        Shape shape = TextLayer.makeTextBlock(this.topText, this.textFont, this.size.width, TextAlignment.CENTER);
        shape = Position.CENTER.createTransformedShape(shape, rectangle);
        ShapeLayer shapeLayer2 = new ShapeLayer(layerComposition, shape, new FillRenderer(this.textColor));
        ShapeLayer shapeLayer3 = new ShapeLayer(layerComposition, shape, new FillRenderer(this.topTextShadowBottomColor));
        shapeLayer3.setTransform(AffineTransform.getTranslateInstance(this.topTextDepth, 0.0));
        Rectangle rectangle2 = shape.getBounds();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(rectangle2.x, rectangle2.y + rectangle2.height);
        affineTransform.scale(1.0, 0.5);
        affineTransform.shear(-0.5, 0.0);
        affineTransform.translate(-rectangle2.x, -rectangle2.y - rectangle2.height);
        Shape shape2 = affineTransform.createTransformedShape(shape);
        Rectangle rectangle3 = shape2.getBounds();
        GradientPaint gradientPaint2 = new GradientPaint(0.0f, rectangle3.y + rectangle3.height, this.topTextShadowBottomColor, 0.0f, rectangle3.y, this.topTextShadowTopColor);
        ShapeLayer shapeLayer4 = new ShapeLayer(layerComposition, shape2, new FillRenderer(gradientPaint2));
        ConvolveOp convolveOp = new ConvolveOp(new GaussianKernel(this.shadowBlurRadius));
        shapeLayer4.setImageFilter(convolveOp, new Dimension(2 * this.shadowBlurRadius, 2 * this.shadowBlurRadius));
        vector.addElement(shapeLayer4);
        vector.addElement(shapeLayer3);
        vector.addElement(shapeLayer2);
        Shape shape3 = this.createWave();
        Rectangle rectangle4 = shape3.getBounds();
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(0.0, -rectangle4.y - rectangle4.height / 3 + this.size.height / 2);
        GradientPaint gradientPaint3 = new GradientPaint(0.0f, rectangle4.y, this.waveTopColor, 0.0f, rectangle4.y + rectangle4.height, this.waveBottomColor);
        FillRenderer fillRenderer = new FillRenderer(gradientPaint3);
        StrokeRenderer strokeRenderer = new StrokeRenderer((Paint)this.waveTopColor, new BasicStroke(this.waveStrokeWidth));
        CompositeRenderer compositeRenderer = new CompositeRenderer(new Renderer[]{fillRenderer, strokeRenderer});
        for (int i = 0; i < this.textWaveIndex; ++i) {
            object = new ShapeLayer(layerComposition, shape3, compositeRenderer);
            ((Layer)object).setTransform((AffineTransform)affineTransform2.clone());
            vector.addElement(object);
            affineTransform2.translate(0.0, 2 * rectangle4.height / 3);
        }
        Rectangle rectangle5 = new Rectangle(0, this.size.height / 2, this.size.width, this.size.height / 2);
        object = TextLayer.makeTextBlock(this.bottomText, this.textFont, this.size.width, TextAlignment.CENTER);
        object = Position.CENTER.createTransformedShape((Shape)object, rectangle5);
        ShapeLayer shapeLayer5 = new ShapeLayer(layerComposition, (Shape)object, new FillRenderer(this.textColor));
        ShapeLayer shapeLayer6 = new ShapeLayer(layerComposition, (Shape)object, new FillRenderer(this.waveTopColor));
        shapeLayer6.setTransform(AffineTransform.getTranslateInstance(this.topTextDepth, 0.0));
        vector.addElement(shapeLayer6);
        vector.addElement(shapeLayer5);
        for (int i = this.textWaveIndex; i < this.numberOfWaves; ++i) {
            objectArray = new ShapeLayer(layerComposition, shape3, compositeRenderer);
            objectArray.setTransform((AffineTransform)affineTransform2.clone());
            vector.addElement(objectArray);
            affineTransform2.translate(0.0, 2 * rectangle4.height / 3);
        }
        ShapeLayer shapeLayer7 = new ShapeLayer(layerComposition, (Shape)object, new FillRenderer(this.textColor));
        shapeLayer7.setComposite(AlphaComposite.getInstance(3, 0.25f));
        vector.addElement(shapeLayer7);
        objectArray = new Layer[vector.size()];
        vector.copyInto(objectArray);
        layerComposition.setLayers((Layer[])objectArray);
        layerComposition.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return layerComposition;
    }
}

