/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.queue;

import com.sosnoski.util.GrowableBase;
import java.lang.reflect.Array;

public abstract class QueueBase
extends GrowableBase {
    protected int m_fillOffset;
    protected int m_emptyOffset;

    public QueueBase(int n, int n2, Class clazz) {
        super(n, n2, clazz);
    }

    public QueueBase(int n, Class clazz) {
        this(n, Integer.MAX_VALUE, clazz);
    }

    public QueueBase(QueueBase queueBase) {
        super(queueBase);
        System.arraycopy(queueBase.getArray(), 0, this.getArray(), 0, this.m_countLimit);
        this.m_fillOffset = queueBase.m_fillOffset;
        this.m_emptyOffset = queueBase.m_emptyOffset;
    }

    protected void resizeCopy(Object object, Object object2) {
        if (this.m_fillOffset < this.m_emptyOffset) {
            int n = Array.getLength(object);
            int n2 = n - this.m_emptyOffset;
            System.arraycopy(object, this.m_emptyOffset, object2, 0, n2);
            System.arraycopy(object, 0, object2, n2, this.m_fillOffset);
            this.m_fillOffset += n;
        } else {
            int n = this.m_fillOffset - this.m_emptyOffset;
            System.arraycopy(object, this.m_emptyOffset, object2, 0, n);
        }
        this.m_fillOffset -= this.m_emptyOffset;
        this.m_emptyOffset = 0;
    }

    protected int getAddIndex() {
        int n = (this.m_fillOffset + 1) % this.m_countLimit;
        if (n == this.m_emptyOffset) {
            this.growArray(this.m_countLimit + 1);
            n = this.m_fillOffset + 1;
        }
        int n2 = this.m_fillOffset;
        this.m_fillOffset = n;
        return n2;
    }

    protected int getRemoveIndex() {
        if (this.m_fillOffset == this.m_emptyOffset) {
            throw new IllegalStateException("Attempted remove from empty queue");
        }
        int n = this.m_emptyOffset;
        this.m_emptyOffset = (this.m_emptyOffset + 1) % this.m_countLimit;
        return n;
    }

    public int size() {
        int n = this.m_fillOffset - this.m_emptyOffset;
        return n >= 0 ? n : n + this.m_countLimit;
    }

    public boolean isEmpty() {
        return this.m_fillOffset == this.m_emptyOffset;
    }

    public void clear() {
        if (this.m_fillOffset >= this.m_emptyOffset) {
            this.discardValues(this.m_emptyOffset, this.m_fillOffset);
        } else {
            this.discardValues(this.m_emptyOffset, this.m_countLimit);
            this.discardValues(0, this.m_fillOffset);
        }
        this.m_emptyOffset = 0;
        this.m_fillOffset = 0;
    }

    public void discard(int n) {
        if (n > this.size()) {
            throw new IllegalStateException("Attempted to discard more items than present on queue");
        }
        int n2 = this.m_emptyOffset + n;
        if (n2 > this.m_countLimit) {
            this.discardValues(this.m_emptyOffset, this.m_countLimit);
            this.discardValues(0, n2 -= this.m_countLimit);
        } else {
            this.discardValues(this.m_emptyOffset, n2);
        }
        this.m_emptyOffset = n2;
    }

    protected Object buildArray(Class clazz) {
        int n = this.size();
        Object object = Array.newInstance(clazz, n);
        if (this.m_fillOffset >= this.m_emptyOffset) {
            System.arraycopy(this.getArray(), this.m_emptyOffset, object, 0, n);
        } else {
            int n2 = this.m_countLimit - this.m_emptyOffset;
            System.arraycopy(this.getArray(), this.m_emptyOffset, object, 0, n2);
            System.arraycopy(this.getArray(), 0, object, n2, this.m_fillOffset);
        }
        return object;
    }
}

