/*
 * Decompiled with CFR 0.152.
 */
package com.sosnoski.util.hashmap;

import com.sosnoski.util.SparseArrayIterator;
import com.sosnoski.util.hashmap.PrimitiveKeyBase;
import java.util.Iterator;

public class IntStringHashMap
extends PrimitiveKeyBase {
    protected int[] m_keyTable;
    protected String[] m_valueTable;
    static /* synthetic */ Class class$java$lang$String;

    public IntStringHashMap(int n, double d) {
        super(n, d, Integer.TYPE, class$java$lang$String == null ? (class$java$lang$String = IntStringHashMap.class$("java.lang.String")) : class$java$lang$String);
    }

    public IntStringHashMap(int n) {
        this(n, 0.3);
    }

    public IntStringHashMap() {
        this(0, 0.3);
    }

    public IntStringHashMap(IntStringHashMap intStringHashMap) {
        super(intStringHashMap);
    }

    protected final Object getKeyArray() {
        return this.m_keyTable;
    }

    protected final void setKeyArray(Object object) {
        this.m_keyTable = (int[])object;
    }

    protected final Object getValueArray() {
        return this.m_valueTable;
    }

    protected final void setValueArray(Object object) {
        this.m_valueTable = (String[])object;
    }

    protected final boolean reinsert(int n) {
        this.m_flagTable[n] = false;
        return this.assignSlot(this.m_keyTable[n], this.m_valueTable[n]) != n;
    }

    protected void restructure(boolean[] blArray, Object object, Object object2) {
        int[] nArray = (int[])object;
        String[] stringArray = (String[])object2;
        int n = 0;
        while (n < blArray.length) {
            if (blArray[n]) {
                this.assignSlot(nArray[n], stringArray[n]);
            }
            ++n;
        }
    }

    protected final int computeSlot(int n) {
        return (n * 517 & Integer.MAX_VALUE) % this.m_flagTable.length;
    }

    protected int assignSlot(int n, String string) {
        int n2 = this.freeSlot(this.computeSlot(n));
        this.m_flagTable[n2] = true;
        this.m_keyTable[n2] = n;
        this.m_valueTable[n2] = string;
        return n2;
    }

    public String add(int n, String string) {
        this.ensureCapacity(this.m_entryCount + 1);
        int n2 = this.internalFind(n);
        if (n2 >= 0) {
            String string2 = this.m_valueTable[n2];
            this.m_valueTable[n2] = string;
            return string2;
        }
        ++this.m_entryCount;
        n2 = -n2 - 1;
        this.m_flagTable[n2] = true;
        this.m_keyTable[n2] = n;
        this.m_valueTable[n2] = string;
        return null;
    }

    protected final int internalFind(int n) {
        int n2 = this.computeSlot(n);
        while (this.m_flagTable[n2]) {
            if (n == this.m_keyTable[n2]) {
                return n2;
            }
            n2 = this.stepSlot(n2);
        }
        return -n2 - 1;
    }

    public final boolean containsKey(int n) {
        return this.internalFind(n) >= 0;
    }

    public final String get(int n) {
        int n2 = this.internalFind(n);
        if (n2 >= 0) {
            return this.m_valueTable[n2];
        }
        return null;
    }

    public String remove(int n) {
        int n2 = this.internalFind(n);
        if (n2 >= 0) {
            String string = this.m_valueTable[n2];
            this.m_flagTable[n2] = false;
            --this.m_entryCount;
            while (this.m_flagTable[n2 = this.stepSlot(n2)]) {
                this.reinsert(n2);
            }
            return string;
        }
        return null;
    }

    public final Iterator valueIterator() {
        return SparseArrayIterator.buildIterator(this.m_valueTable);
    }

    public Object clone() {
        return new IntStringHashMap(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

