/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui;

import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.experiment.annotation.gene.GeneFactory;
import com.compomics.util.experiment.annotation.go.GOFactory;
import com.compomics.util.experiment.identification.matches.ProteinMatch;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import no.uib.jsparklines.extra.HtmlLinksRenderer;

public class GeneDetailsDialog
extends JDialog {
    private GOFactory goFactory = GOFactory.getInstance();
    private GeneFactory geneFactory = GeneFactory.getInstance();
    private ArrayList<String> proteinAccessions;
    private ArrayList<String> goTermDescriptions;
    private String selectedRowHtmlTagFontColor = "#FFFFFF";
    private String notSelectedRowHtmlTagFontColor = "#0101DF";
    private JPanel backgroundPanel;
    private JLabel chromosomeLabel;
    private JTextField chromosomeNameTxt;
    private JPanel detailsPanel;
    private JLabel ensemlbIdLabel;
    private JTextField geneIdTxt;
    private JLabel geneNameLabel;
    private JTextField geneNameTxt;
    private JLabel goAnnotationLabel;
    private JTable goTable;
    private JScrollPane goTableScrollPane;
    private JButton okButton;

    public GeneDetailsDialog(Frame parent, String proteinMatchKey) throws IOException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        super(parent, true);
        this.initComponents();
        this.proteinAccessions = new ArrayList<String>(Arrays.asList(ProteinMatch.getAccessions(proteinMatchKey)));
        this.goTermDescriptions = this.goFactory.getProteinGoDescriptions(proteinMatchKey);
        Collections.sort(this.goTermDescriptions);
        this.setUpGUI();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void setUpGUI() throws IOException, InterruptedException, FileNotFoundException, ClassNotFoundException {
        this.goTable.getColumn("Accession").setCellRenderer((TableCellRenderer)new HtmlLinksRenderer(this.selectedRowHtmlTagFontColor, this.notSelectedRowHtmlTagFontColor));
        Integer width = this.getPreferredAccessionColumnWidth(this.goTable, this.goTable.getColumn("Accession").getModelIndex(), 20);
        if (width != null) {
            this.goTable.getColumn("Accession").setMinWidth(width);
            this.goTable.getColumn("Accession").setMaxWidth(width);
        } else {
            this.goTable.getColumn("Accession").setMinWidth(15);
            this.goTable.getColumn("Accession").setMaxWidth(Integer.MAX_VALUE);
        }
        this.goTable.getColumn(" ").setMaxWidth(50);
        this.goTable.getColumn(" ").setMinWidth(50);
        this.goTable.getTableHeader().setReorderingAllowed(false);
        this.goTable.setAutoCreateRowSorter(true);
        JPanel proteinCorner = new JPanel();
        proteinCorner.setBackground(this.goTable.getTableHeader().getBackground());
        this.goTableScrollPane.setCorner("UPPER_RIGHT_CORNER", proteinCorner);
        this.goTableScrollPane.getViewport().setOpaque(false);
        String title = "";
        String geneIdsTxt = "";
        String geneNamesTxt = "";
        String chromosomeTxt = "";
        ArrayList<String> geneNames = new ArrayList<String>();
        for (String accession : this.proteinAccessions) {
            title = title.equals("") ? title + "Gene details for " : title + ", ";
            title = title + accession;
            String geneName = this.geneFactory.getGeneNameForUniProtProtein(accession);
            geneNames.add(geneName);
        }
        ArrayList<String> chromosomes = new ArrayList<String>();
        for (String geneName : geneNames) {
            if (!geneIdsTxt.equals("")) {
                geneIdsTxt = geneIdsTxt + ", ";
                geneNamesTxt = geneNamesTxt + ", ";
            }
            if (geneName == null) {
                geneNamesTxt = geneNamesTxt + "unknown";
                geneIdsTxt = geneIdsTxt + "unknown";
                continue;
            }
            String ensemblId = this.geneFactory.getGeneEnsemblId(geneName);
            geneIdsTxt = ensemblId == null ? geneIdsTxt + "unknown" : geneIdsTxt + ensemblId;
            geneNamesTxt = geneNamesTxt + geneName;
            String chromosome = this.geneFactory.getChromosomeForGeneName(geneName);
            chromosomes.add(chromosome);
        }
        if (chromosomes.isEmpty()) {
            chromosomeTxt = "unknown";
        } else {
            for (String chromosome : chromosomes) {
                if (!chromosomeTxt.equals("")) {
                    chromosomeTxt = chromosomeTxt + ", ";
                }
                if (chromosome == null) {
                    chromosomeTxt = chromosomeTxt + "unknown";
                    continue;
                }
                chromosomeTxt = chromosomeTxt + chromosome;
            }
        }
        ((TitledBorder)this.detailsPanel.getBorder()).setTitle(title);
        this.geneIdTxt.setText(geneIdsTxt);
        this.geneNameTxt.setText(geneNamesTxt);
        this.chromosomeNameTxt.setText(chromosomeTxt);
    }

    private void initComponents() {
        this.backgroundPanel = new JPanel();
        this.detailsPanel = new JPanel();
        this.ensemlbIdLabel = new JLabel();
        this.geneIdTxt = new JTextField();
        this.geneNameTxt = new JTextField();
        this.geneNameLabel = new JLabel();
        this.chromosomeLabel = new JLabel();
        this.chromosomeNameTxt = new JTextField();
        this.goAnnotationLabel = new JLabel();
        this.goTableScrollPane = new JScrollPane();
        this.goTable = new JTable();
        this.okButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Gene Details");
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.detailsPanel.setBorder(BorderFactory.createTitledBorder("Gene Details"));
        this.detailsPanel.setOpaque(false);
        this.ensemlbIdLabel.setText("Ensembl Gene ID");
        this.geneIdTxt.setEditable(false);
        this.geneNameTxt.setEditable(false);
        this.geneNameLabel.setText("Gene Name");
        this.chromosomeLabel.setText("Chromosome");
        this.chromosomeNameTxt.setEditable(false);
        this.goAnnotationLabel.setText("GO Annotation");
        this.goTable.setModel(new GOTableModel());
        this.goTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                GeneDetailsDialog.this.goTableMouseReleased(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                GeneDetailsDialog.this.goTableMouseExited(evt);
            }
        });
        this.goTable.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent evt) {
                GeneDetailsDialog.this.goTableMouseMoved(evt);
            }
        });
        this.goTableScrollPane.setViewportView(this.goTable);
        GroupLayout detailsPanelLayout = new GroupLayout(this.detailsPanel);
        this.detailsPanel.setLayout(detailsPanelLayout);
        detailsPanelLayout.setHorizontalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.goTableScrollPane, -1, 707, Short.MAX_VALUE).addGroup(detailsPanelLayout.createSequentialGroup().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ensemlbIdLabel, -2, 110, -2).addComponent(this.geneNameLabel, -2, 110, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.geneNameTxt).addComponent(this.geneIdTxt))).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.goAnnotationLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(detailsPanelLayout.createSequentialGroup().addComponent(this.chromosomeLabel, -2, 110, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.chromosomeNameTxt))).addContainerGap()));
        detailsPanelLayout.setVerticalGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(detailsPanelLayout.createSequentialGroup().addContainerGap().addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ensemlbIdLabel).addComponent(this.geneIdTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.geneNameLabel).addComponent(this.geneNameTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(detailsPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chromosomeLabel).addComponent(this.chromosomeNameTxt, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.goAnnotationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.goTableScrollPane, -1, 206, Short.MAX_VALUE).addContainerGap()));
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GeneDetailsDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.detailsPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 86, -2))).addContainerGap()));
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.detailsPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void goTableMouseReleased(MouseEvent evt) {
        int row = this.goTable.getSelectedRow();
        int column = this.goTable.getSelectedColumn();
        if (row != -1) {
            this.setCursor(new Cursor(3));
            if (evt != null && evt.getButton() == 1 && column == this.goTable.getColumn("Accession").getModelIndex() && ((String)this.goTable.getValueAt(row, column)).lastIndexOf("<html>") != -1) {
                String link = (String)this.goTable.getValueAt(row, column);
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                this.setCursor(new Cursor(3));
                BareBonesBrowserLaunch.openURL(link);
                this.setCursor(new Cursor(0));
            }
            this.setCursor(new Cursor(0));
        }
    }

    private void goTableMouseMoved(MouseEvent evt) {
        int row = this.goTable.rowAtPoint(evt.getPoint());
        int column = this.goTable.columnAtPoint(evt.getPoint());
        if (column == this.goTable.getColumn("Accession").getModelIndex() && this.goTable.getValueAt(row, column) != null) {
            String tempValue = (String)this.goTable.getValueAt(row, column);
            if (tempValue.lastIndexOf("<html>") != -1) {
                this.setCursor(new Cursor(12));
            } else {
                this.setCursor(new Cursor(0));
            }
        } else {
            this.setCursor(new Cursor(0));
        }
    }

    private void goTableMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    public String addGoLink(String goAccession) {
        return "<html><a href=\"" + this.getGoAccessionLink(goAccession) + "\"><font color=\"" + this.notSelectedRowHtmlTagFontColor + "\">" + goAccession + "</font></a></html>";
    }

    public String getGoAccessionLink(String goAccession) {
        return "http://www.ebi.ac.uk/QuickGO/GTerm?id=" + goAccession;
    }

    public Integer getPreferredAccessionColumnWidth(JTable table, int colIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(colIndex);
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        int width = comp.getPreferredSize().width;
        return width += 2 * margin;
    }

    private class GOTableModel
    extends DefaultTableModel {
        private GOTableModel() {
        }

        @Override
        public int getRowCount() {
            if (GeneDetailsDialog.this.goTermDescriptions != null) {
                return GeneDetailsDialog.this.goTermDescriptions.size();
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "Accession";
                }
                case 2: {
                    return "Description";
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    try {
                        return GeneDetailsDialog.this.addGoLink(GeneDetailsDialog.this.goFactory.getTermAccession((String)GeneDetailsDialog.this.goTermDescriptions.get(row)));
                    }
                    catch (Exception e) {
                        return "Error";
                    }
                }
                case 2: {
                    try {
                        return GeneDetailsDialog.this.goTermDescriptions.get(row);
                    }
                    catch (Exception e) {
                        return "Error";
                    }
                }
            }
            return "";
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    }
}

