/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;

public class CircularRangeLocation
implements Location,
Serializable {
    private int min;
    private int max;
    private int realMin;
    private int realMax;
    private int length;
    private boolean overlap;

    public CircularRangeLocation(int n, int n2, int n3) {
        this.min = n;
        this.max = n2;
        this.length = n3;
        this.realMin = this.realValue(n);
        this.realMax = this.realValue(n2);
        this.overlap = this.realMin > this.realMax ? true : this.realMin == 1 && this.realMax == n3;
    }

    public Iterator blockIterator() {
        return Collections.singleton(this).iterator();
    }

    public boolean contains(int n) {
        n = this.realValue(n);
        this.overlap = true;
        if (true) {
            return this.getMin() >= n || this.getMax() <= n;
        }
        return this.getMin() <= n && this.getMax() >= n;
    }

    public boolean contains(Location location) {
        if (this.overlapsOrigin() && location.getClass().isInstance(this)) {
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            if (circularRangeLocation.overlapsOrigin()) {
                return this.getMin() <= circularRangeLocation.getMin() && this.getMax() >= circularRangeLocation.getMax();
            }
            return this.getMin() <= circularRangeLocation.getMin() && this.length >= circularRangeLocation.getMax();
        }
        if (!this.overlapsOrigin() && location.getClass().isInstance(this)) {
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            if (circularRangeLocation.overlapsOrigin()) {
                return false;
            }
            return this.getMin() <= location.getMin() && this.getMax() >= location.getMax();
        }
        return this.getMin() <= location.getMin() && this.getMax() >= location.getMax();
    }

    public boolean equals(Location location) {
        if (location.getClass().isInstance(this)) {
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            return this.getMin() == circularRangeLocation.getMin() && this.getMax() == circularRangeLocation.getMax() && this.overlapsOrigin() == circularRangeLocation.overlapsOrigin();
        }
        if (this.overlapsOrigin()) {
            return false;
        }
        return this.getMin() == location.getMin() && this.getMax() == location.getMax() && location.isContiguous();
    }

    public int getMax() {
        return this.realMax;
    }

    public int getMin() {
        return this.realMin;
    }

    public Location intersection(Location location) {
        int n;
        if (location.getClass().isInstance(this) && this.overlapsOrigin()) {
            int n2;
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            if (circularRangeLocation.overlapsOrigin()) {
                int n3 = Math.max(this.getMin(), circularRangeLocation.getMin());
                int n4 = Math.min(this.getMax(), circularRangeLocation.getMax());
                return new CircularRangeLocation(n3, n4, this.length);
            }
            int n5 = Math.max(this.getMin(), circularRangeLocation.getMin());
            if (n5 <= (n2 = Math.min(this.length, circularRangeLocation.getMax()))) {
                return new CircularRangeLocation(n5, n2, this.length);
            }
            return Location.empty;
        }
        if (!this.overlapsOrigin() && location.getClass().isInstance(this)) {
            int n6;
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            if (circularRangeLocation.overlapsOrigin()) {
                int n7;
                int n8 = Math.max(this.getMin(), circularRangeLocation.getMin());
                if (n8 <= (n7 = Math.min(this.getMax(), this.length))) {
                    return new CircularRangeLocation(n8, n7, this.length);
                }
                return Location.empty;
            }
            int n9 = Math.max(this.getMin(), circularRangeLocation.getMin());
            if (n9 <= (n6 = Math.min(this.getMax(), circularRangeLocation.getMax()))) {
                return new CircularRangeLocation(n9, n6, this.length);
            }
            return Location.empty;
        }
        int n10 = Math.max(this.getMin(), location.getMin());
        if (n10 <= (n = Math.min(this.getMax(), location.getMax()))) {
            return new CircularRangeLocation(n10, n, this.length);
        }
        return Location.empty;
    }

    public boolean isContiguous() {
        return true;
    }

    public boolean overlaps(Location location) {
        if (this.overlapsOrigin() && location.getClass().isInstance(this)) {
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            if (circularRangeLocation.overlapsOrigin()) {
                return true;
            }
            return circularRangeLocation.getMax() > this.getMax() || circularRangeLocation.getMin() < this.getMin() || this.getMin() == 1 && this.getMax() == this.length;
        }
        if (!this.overlapsOrigin() && location.getClass().isInstance(this)) {
            CircularRangeLocation circularRangeLocation = (CircularRangeLocation)location;
            if (circularRangeLocation.overlapsOrigin()) {
                return this.getMax() > circularRangeLocation.getMax() || this.getMin() < circularRangeLocation.getMin() || circularRangeLocation.getMin() == 1 && circularRangeLocation.getMax() == this.length;
            }
            return (this.getMin() > location.getMax() || this.getMax() < location.getMin()) ^ true;
        }
        return (this.getMin() > location.getMax() || this.getMax() < location.getMin()) ^ true;
    }

    public boolean overlapsOrigin() {
        return this.overlap;
    }

    private int realValue(int n) {
        if ((n = (n - 1) % this.length + 1) < 0) {
            n = this.length + 1 + n;
        }
        return n;
    }

    public SymbolList symbols(SymbolList symbolList) {
        return symbolList.subList(this.getMin(), this.getMax());
    }

    public String toString() {
        return "[" + this.getMin() + ", " + this.getMax() + "]";
    }

    public Location translate(int n) {
        return new CircularRangeLocation(this.getMin() + n, this.getMax() + n, this.length);
    }

    public Location union(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>(2);
        arrayList.add(this);
        arrayList.add(location);
        return new CompoundLocation(arrayList);
    }
}

