/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;

class SubArraySymbolList
extends AbstractSymbolList {
    private final Alphabet alpha;
    private final int length;
    private final int offset;
    private final Symbol[] array;

    SubArraySymbolList(Symbol[] symbolArray, int n, int n2, Alphabet alphabet) {
        this.alpha = alphabet;
        this.length = n;
        this.offset = n2;
        this.array = symbolArray;
        if (n + n2 > symbolArray.length) {
            throw new IndexOutOfBoundsException();
        }
        alphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alpha.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public Alphabet getAlphabet() {
        return this.alpha;
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int n) {
        if (n < 1 || n > this.length) {
            throw new IndexOutOfBoundsException("Index out of range: " + n);
        }
        return this.array[this.offset + n - 1];
    }
}

