/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.sax;

import java.util.HashMap;
import java.util.StringTokenizer;
import org.biojava.bio.program.sax.BlastLikeVersionSupport;
import org.xml.sax.SAXException;

final class HSPSummaryHelper {
    private HSPSummaryHelper() {
    }

    public static void parse(String string, HashMap hashMap, BlastLikeVersionSupport blastLikeVersionSupport) throws SAXException {
        int n = blastLikeVersionSupport.getProgram();
        if (n == 1 || n == 3 || n == 2 || n == 4 || n == 5) {
            HSPSummaryHelper.parseNCBIBlast(string, hashMap, blastLikeVersionSupport);
            return;
        }
        if (n == 11 || n == 13 || n == 12 || n == 14 || n == 15) {
            HSPSummaryHelper.parseWUBlast(string, hashMap, blastLikeVersionSupport);
            return;
        }
        throw new SAXException("Failed attempting to parse an HSP Summary because program ".concat(blastLikeVersionSupport.getProgramString()).concat(" is not supported."));
    }

    static void parseNCBIBlast(String string, HashMap hashMap, BlastLikeVersionSupport blastLikeVersionSupport) {
        StringBuffer stringBuffer = new StringBuffer();
        hashMap.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                char[] cArray;
                StringTokenizer stringTokenizer3;
                String string3;
                String string4;
                String string5 = stringTokenizer2.nextToken().trim();
                if (string5.equals("score")) {
                    string4 = "score";
                    stringTokenizer2.nextToken();
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.startsWith("expect")) {
                    string4 = "expectValue";
                    stringTokenizer2.nextToken();
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.equals("identities")) {
                    stringTokenizer2.nextToken();
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "/");
                    string4 = "numberOfIdentities";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    string4 = "alignmentSize";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "(%)");
                    string4 = "percentageIdentity";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.equals("positives")) {
                    stringTokenizer2.nextToken();
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "/");
                    string4 = "numberOfPositives";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "(%)");
                    string4 = "percentagePositives";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.equals("strand")) {
                    stringTokenizer2.nextToken();
                    string4 = "queryStrand";
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    stringTokenizer2.nextToken();
                    string4 = "hitStrand";
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (!string5.equals("frame")) continue;
                stringTokenizer2.nextToken();
                if (blastLikeVersionSupport.getProgram() == 3) {
                    string4 = "queryFrame";
                    cArray = stringTokenizer2.nextToken().toCharArray();
                    stringBuffer.setLength(0);
                    if (cArray[0] == '+') {
                        stringBuffer.append("plus");
                    } else {
                        stringBuffer.append("minus");
                    }
                    stringBuffer.append(cArray[1]);
                    string3 = stringBuffer.toString();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (blastLikeVersionSupport.getProgram() == 4) {
                    string4 = "hitFrame";
                    cArray = stringTokenizer2.nextToken().toCharArray();
                    stringBuffer.setLength(0);
                    if (cArray[0] == '+') {
                        stringBuffer.append("plus");
                    } else {
                        stringBuffer.append("minus");
                    }
                    stringBuffer.append(cArray[1]);
                    string3 = stringBuffer.toString();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (blastLikeVersionSupport.getProgram() != 5) continue;
                string4 = "queryFrame";
                cArray = stringTokenizer2.nextToken().toCharArray();
                stringBuffer.setLength(0);
                if (cArray[0] == '+') {
                    stringBuffer.append("plus");
                } else {
                    stringBuffer.append("minus");
                }
                stringBuffer.append(cArray[1]);
                string3 = stringBuffer.toString();
                hashMap.put(string4, string3);
                stringTokenizer2.nextToken();
                string4 = "hitFrame";
                cArray = stringTokenizer2.nextToken().toCharArray();
                stringBuffer.setLength(0);
                if (cArray[0] == '+') {
                    stringBuffer.append("plus");
                } else {
                    stringBuffer.append("minus");
                }
                stringBuffer.append(cArray[1]);
                string3 = stringBuffer.toString();
                hashMap.put(string4, string3);
                continue block0;
            }
        }
    }

    static void parseWUBlast(String string, HashMap hashMap, BlastLikeVersionSupport blastLikeVersionSupport) {
        StringBuffer stringBuffer = new StringBuffer();
        hashMap.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(), ",");
        block0: while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                char[] cArray;
                StringTokenizer stringTokenizer3;
                String string3;
                String string4;
                String string5 = stringTokenizer2.nextToken().trim();
                if (string5.equals("score")) {
                    string4 = "score";
                    stringTokenizer2.nextToken();
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.startsWith("expect")) {
                    string4 = "expectValue";
                    stringTokenizer2.nextToken();
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.equals("identities")) {
                    stringTokenizer2.nextToken();
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "/");
                    string4 = "numberOfIdentities";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    string4 = "alignmentSize";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "(%)");
                    string4 = "percentageIdentity";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.equals("positives")) {
                    stringTokenizer2.nextToken();
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "/");
                    string4 = "numberOfPositives";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken(), "(%)");
                    string4 = "percentagePositives";
                    string3 = stringTokenizer3.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (string5.equals("strand")) {
                    stringTokenizer2.nextToken();
                    string4 = "queryStrand";
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    stringTokenizer2.nextToken();
                    string4 = "hitStrand";
                    string3 = stringTokenizer2.nextToken();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (!string5.equals("frame")) continue;
                stringTokenizer2.nextToken();
                if (blastLikeVersionSupport.getProgram() == 13) {
                    string4 = "queryFrame";
                    cArray = stringTokenizer2.nextToken().toCharArray();
                    stringBuffer.setLength(0);
                    if (cArray[0] == '+') {
                        stringBuffer.append("plus");
                    } else {
                        stringBuffer.append("minus");
                    }
                    stringBuffer.append(cArray[1]);
                    string3 = stringBuffer.toString();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (blastLikeVersionSupport.getProgram() == 14) {
                    string4 = "hitFrame";
                    cArray = stringTokenizer2.nextToken().toCharArray();
                    stringBuffer.setLength(0);
                    if (cArray[0] == '+') {
                        stringBuffer.append("plus");
                    } else {
                        stringBuffer.append("minus");
                    }
                    stringBuffer.append(cArray[1]);
                    string3 = stringBuffer.toString();
                    hashMap.put(string4, string3);
                    continue block0;
                }
                if (blastLikeVersionSupport.getProgram() != 15) continue;
                string4 = "queryFrame";
                cArray = stringTokenizer2.nextToken().toCharArray();
                stringBuffer.setLength(0);
                if (cArray[0] == '+') {
                    stringBuffer.append("plus");
                } else {
                    stringBuffer.append("minus");
                }
                stringBuffer.append(cArray[1]);
                string3 = stringBuffer.toString();
                hashMap.put(string4, string3);
                stringTokenizer2.nextToken();
                string4 = "hitFrame";
                cArray = stringTokenizer2.nextToken().toCharArray();
                stringBuffer.setLength(0);
                if (cArray[0] == '+') {
                    stringBuffer.append("plus");
                } else {
                    stringBuffer.append("minus");
                }
                stringBuffer.append(cArray[1]);
                string3 = stringBuffer.toString();
                hashMap.put(string4, string3);
                continue block0;
            }
        }
    }
}

