/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.tools.xxindex;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import psidev.psi.tools.xxindex.SimpleXmlElementExtractor;
import psidev.psi.tools.xxindex.XmlElementExtractor;
import psidev.psi.tools.xxindex.XpathAccess;
import psidev.psi.tools.xxindex.index.ByteBuffer;
import psidev.psi.tools.xxindex.index.IndexElement;
import psidev.psi.tools.xxindex.index.XmlElement;
import psidev.psi.tools.xxindex.index.XmlXpathIndexer;
import psidev.psi.tools.xxindex.index.XpathIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardXpathAccess
implements XpathAccess {
    private static final Log log = LogFactory.getLog(StandardXpathAccess.class);
    private File file;
    private XpathIndex index;
    private XmlElementExtractor extractor;
    private boolean ignoreNSPrefix = true;

    public StandardXpathAccess(File file) throws IOException {
        this(file, null);
    }

    public StandardXpathAccess(File file, Set<String> aXpathInclusionSet) throws IOException {
        this(file, aXpathInclusionSet, true);
    }

    public StandardXpathAccess(File file, Set<String> aXpathInclusionSet, boolean recordLineNumbers) throws IOException {
        this.file = file;
        this.index = XmlXpathIndexer.buildIndex(new FileInputStream(file), aXpathInclusionSet, recordLineNumbers);
        this.extractor = new SimpleXmlElementExtractor();
        String enc = this.extractor.detectFileEncoding(file.toURI().toURL());
        if (enc != null) {
            this.extractor.setEncoding(enc);
        }
    }

    @Override
    public XpathIndex getIndex() {
        return this.index;
    }

    public boolean isIgnoreNSPrefix() {
        return this.ignoreNSPrefix;
    }

    public void setIgnoreNSPrefix(boolean ignoreNSPrefix) {
        this.ignoreNSPrefix = ignoreNSPrefix;
    }

    @Override
    public List<String> getXmlSnippets(String xpath) throws IOException {
        return this.getXmlSnippets(xpath, null, null);
    }

    public List<String> getXmlSnippets(String xpath, Long start, Long stop) throws IOException {
        ArrayList<String> results = new ArrayList<String>();
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> ranges = this.index.getElements(xpath);
            for (IndexElement range : ranges) {
                if (start != null && range.getStart() < start || stop != null && range.getStop() > stop) continue;
                results.add(this.extractor.readString(range.getStart(), range.getStop(), this.file));
            }
        } else {
            log.error("The index does not contain any entry for the requested xpath: " + xpath);
        }
        return results;
    }

    @Override
    public Iterator<String> getXmlSnippetIterator(String xpath) {
        return this.getXmlSnippetIterator(xpath, null, null);
    }

    @Override
    public Iterator<String> getXmlSnippetIterator(String xpath, Long start, Long stop) {
        XmlSnippetIterator iter;
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> ranges = this.index.getElements(xpath);
            iter = new XmlSnippetIterator(ranges, this.extractor, this.file, start, stop);
        } else {
            log.error("The index does not contain any entry for the requested xpath: " + xpath);
            List s = Collections.emptyList();
            iter = s.iterator();
        }
        return iter;
    }

    public int getXmlElementCount(String xpath) {
        return this.index.getElementCount(xpath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStartTag(IndexElement element) throws IOException {
        String startTag = null;
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(this.file);
            fis.getChannel().position(element.getStart());
            bis = new BufferedInputStream(fis);
            boolean stopFound = false;
            ByteBuffer bb = new ByteBuffer();
            byte[] buffer = new byte[1];
            while (!stopFound) {
                bis.read(buffer);
                byte read = buffer[0];
                bb.append(read);
                if (read != 62) continue;
                stopFound = true;
            }
            startTag = bb.toString("ASCII");
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e2) {}
        }
        return startTag;
    }

    public List<XmlElement> getXmlElements(String xpath) throws IOException {
        return this.getXmlElements(xpath, null, null);
    }

    public List<XmlElement> getXmlElements(String xpath, Long start, Long stop) throws IOException {
        ArrayList<XmlElement> results = new ArrayList<XmlElement>();
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> elements = this.index.getElements(xpath);
            for (IndexElement element : elements) {
                if (start != null && element.getStart() < start || stop != null && element.getStop() > stop) continue;
                String tmp = this.extractor.readString(element.getStart(), element.getStop(), this.file);
                long posTmp = element.getLineNumber();
                results.add(new XmlElement(tmp, posTmp));
            }
        } else {
            log.error("The index does not contain any entry for the requested xpath: " + xpath);
        }
        return results;
    }

    public Iterator<XmlElement> getXmlElementIterator(String xpath) {
        return this.getXmlElementIterator(xpath, null, null);
    }

    public Iterator<XmlElement> getXmlElementIterator(String xpath, Long start, Long stop) {
        XmlElementIterator iter;
        if (this.index.containsXpath(xpath)) {
            List<IndexElement> elements = this.index.getElements(xpath);
            iter = new XmlElementIterator(elements, this.extractor, this.file, start, stop);
        } else {
            log.error("The index does not contain any entry for the requested xpath: " + xpath);
            List s = Collections.emptyList();
            iter = s.iterator();
        }
        return iter;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmlElementIterator
    implements Iterator<XmlElement> {
        private Iterator<IndexElement> iterator;
        private XmlElementExtractor extractor;
        private File file;

        public XmlElementIterator(List<IndexElement> elements, XmlElementExtractor extractor, File file) {
            this.iterator = elements.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        public XmlElementIterator(List<IndexElement> elements, XmlElementExtractor extractor, File file, Long start, Long stop) {
            List<IndexElement> validElements;
            if (start == null && stop == null) {
                validElements = elements;
            } else {
                validElements = new ArrayList<IndexElement>();
                for (IndexElement element : elements) {
                    if (start != null && element.getStart() < start || stop != null && element.getStop() > stop) continue;
                    validElements.add(element);
                }
            }
            this.iterator = validElements.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public XmlElement next() {
            XmlElement result;
            IndexElement element = this.iterator.next();
            try {
                String xmlSnippet = this.extractor.readString(element.getStart(), element.getStop(), this.file);
                long position = element.getLineNumber();
                result = new XmlElement(xmlSnippet, position);
            }
            catch (IOException e2) {
                throw new IllegalStateException("Caught IOException while reading from file: " + this.file.getName());
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XmlSnippetIterator
    implements Iterator<String> {
        private Iterator<IndexElement> iterator;
        private XmlElementExtractor extractor;
        private File file;

        public XmlSnippetIterator(List<IndexElement> ranges, XmlElementExtractor extractor, File file) {
            this.iterator = ranges.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        public XmlSnippetIterator(List<IndexElement> elements, XmlElementExtractor extractor, File file, Long start, Long stop) {
            List<IndexElement> validElements;
            if (start == null && stop == null) {
                validElements = elements;
            } else {
                validElements = new ArrayList<IndexElement>();
                for (IndexElement element : elements) {
                    if (start != null && element.getStart() < start || stop != null && element.getStop() > stop) continue;
                    validElements.add(element);
                }
            }
            this.iterator = validElements.iterator();
            this.extractor = extractor;
            this.file = file;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            String result;
            IndexElement range = this.iterator.next();
            try {
                result = this.extractor.readString(range.getStart(), range.getStop(), this.file);
            }
            catch (IOException e2) {
                throw new IllegalStateException("Caught IOException while reading from file: " + this.file.getName(), e2);
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

