## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  error = FALSE,
  warning = FALSE,
  message = FALSE,
    crop = NULL
)
stopifnot(requireNamespace("htmltools"))
htmltools::tagList(rmarkdown::html_dependency_font_awesome())
sce <- readRDS("sce.rds")    

## ----init---------------------------------------------------------------------
library(iSEE)
init <- DataFrame(
    Name = c("Feature assay plot 1", "Feature assay plot 2"),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init)

## ----fexArg-------------------------------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 2)
fexArg$YAxisFeatName <- c("0610009L18Rik", "0610009B22Rik")
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg)

## ----yaxis--------------------------------------------------------------------
cdArgs <- colDataPlotDefaults(sce, 2)
cdArgs$DataBoxOpen <- TRUE
cdArgs$YAxis <- c("NREADS", "TOTAL_DUP")
init <- DataFrame(
    Name = c("Column data plot 1", "Column data plot 2"),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, colDataArgs = cdArgs)

## ----xaxis--------------------------------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 4)
fexArg$DataBoxOpen <- TRUE

# Example 1
fexArg[1, "XAxis"] <- "None"

# Example 2
fexArg[2, "XAxis"] <- "Column data"
fexArg[2, "XAxisColData"] <- "Core.Type"

# Example 3a
fexArg[3, "XAxis"] <- "Feature name"
fexArg[3, "XAxisFeatName"] <- "Zyx"

# Example 3b (also requires a row statistic table)
fexArg[4, "XAxis"] <- "Feature name"
fexArg[4, "XAxisRowTable"] <- "Row statistics table 1"
rowData(sce)[, "gene_id"] <- rownames(sce)
rsArg <- rowStatTableDefaults(sce, 1)
rsArg$Selected <- "Ints2"
rsArg$SearchColumns <- list(gene_id="Ints")

# Initialisation
init <- DataFrame(
    Name = c(
        paste("Feature assay plot", 1:4),
        "Row statistics table 1"),
    Width = c(rep(6, 4), 12)
)
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg, rowStatArgs = rsArg)

## ----redDimPlotDefaults-type--------------------------------------------------
rdArgs <- redDimPlotDefaults(sce, 1)
rdArgs$DataBoxOpen <- TRUE
rdArgs$Type <- "TSNE"
rdArgs$XAxis <- 2
rdArgs$YAxis <- 1
init <- DataFrame(
    Name = c("Reduced dimension plot 1"),
    Width = c(6)
)
app <- iSEE(sce, initialPanels = init, redDimArgs = rdArgs)

## ----featAssayPlotDefaults-assay----------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 2)
fexArg$DataBoxOpen <- TRUE
fexArg$Assay <- c("rsem_counts", "tophat_counts")
init <- DataFrame(
    Name = paste("Feature assay plot", 1:2),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg)

## ----ColorByDefaultColor------------------------------------------------------
cdArgs <- colDataPlotDefaults(sce, 2)
cdArgs$VisualBoxOpen <- TRUE
cdArgs$VisualChoices <- list(c("Color", "Points", "Other"), c("Color", "Points", "Other"))
cdArgs$ColorByDefaultColor[2] <- c("chocolate3")
cdArgs$PointAlpha[2] <- 0.2
cdArgs$PointSize[2] <- 2
cdArgs$Downsample[2] <- TRUE
cdArgs$SampleRes[2] <- 150
cdArgs$FontSize[2] <- 2

init <- DataFrame(
    Name = c("Column data plot 1", "Column data plot 2"),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, colDataArgs = cdArgs)

## ----aesthetic-covariate------------------------------------------------------
cdArgs <- colDataPlotDefaults(sce, 2)
cdArgs$VisualBoxOpen <- TRUE
cdArgs$VisualChoices <- list(c("Color", "Shape"), c("Color", "Shape"))
cdArgs$ColorBy <- "Column data"
cdArgs$ShapeBy <- "Column data"
cdArgs$ColorByColData <- c("Core.Type", "TOTAL_DUP")
cdArgs$ShapeByColData <- c("Core.Type", "driver_1_s")

init <- DataFrame(
    Name = c("Column data plot 1", "Column data plot 2"),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, colDataArgs = cdArgs)

## ----facet--------------------------------------------------------------------
cdArgs <- colDataPlotDefaults(sce, 3)
cdArgs$VisualBoxOpen <- TRUE
cdArgs$VisualChoices <- list("Facets", "Facets", "Facets")
cdArgs$FacetByRow <- c(TRUE, FALSE, TRUE)
cdArgs$FacetByColumn <- c(FALSE, TRUE, TRUE)
cdArgs$RowFacetByColData <- "driver_1_s"
cdArgs$ColumnFacetByColData <- "Core.Type"
init <- DataFrame(
    Name = paste("Column data plot", 1:3),
    Width = c(4, 4, 4)
)
app <- iSEE(sce, initialPanels = init, colDataArgs = cdArgs)

## ----select-brish-------------------------------------------------------------
# Preconfigure the receiver panel
cdArgs <- colDataPlotDefaults(sce, 1)
cdArgs$SelectBoxOpen <- TRUE
cdArgs$SelectByPlot <- "Reduced dimension plot 1"
cdArgs$SelectEffect <- "Color"
cdArgs$SelectColor <- "darkgoldenrod1"

# Preconfigure the sender panel, including the point selection
rdArgs <- redDimPlotDefaults(sce, 1)
rdArgs$BrushData <- list(
        list(xmin = 2.8, xmax = 10.4, ymin = 0.6, ymax = 13.2, 
        mapping = list(x = "X", y = "Y"), domain = list(left = -14.0, right = 10.9, 
            bottom = -12.0, top = 16.4), range = list(left = 38.7, 
            right = 541.5, bottom = 466.0, top = 23.7), 
        log = list(x = NULL, y = NULL), direction = "xy", brushId = "redDimPlot1_Brush", 
        outputId = "redDimPlot1")
    )

init <- DataFrame(
    Name = c("Reduced dimension plot 1", "Column data plot 1"),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, redDimArgs = rdArgs, colDataArgs = cdArgs)

## ----select-lasso-------------------------------------------------------------
# Preconfigure the receiver panel
cdArgs <- colDataPlotDefaults(sce, 1)
cdArgs$SelectBoxOpen <- TRUE
cdArgs$SelectByPlot <- "Reduced dimension plot 1"
cdArgs$SelectEffect <- "Color"
cdArgs$SelectColor <- "darkgoldenrod1"

# Preconfigure the sender panel, including the point selection
rdArgs <- redDimPlotDefaults(sce, 1)
rdArgs$LassoData <- list(
    list(lasso = NULL, closed = TRUE, panelvar1 = NULL, panelvar2 = NULL, mapping = list(
        x = "X", y = "Y"), coord = structure(c(9.7, 4.0, 2.0, 
        8.2, 10.5, 9.7, 9.0, 12.8, 7.9, 0.9, 2.1, 9.0), .Dim = c(6L, 
        2L)))
    )

init <- DataFrame(
    Name = c("Reduced dimension plot 1", "Column data plot 1"),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, redDimArgs = rdArgs, colDataArgs = cdArgs)

## ----integer------------------------------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 2)
fexArg$DataBoxOpen <- TRUE
fexArg$Assay <- c(6, 6)
fexArg$YAxisFeatName <- c(10, 11)
fexArg$XAxis <- "Feature name"
fexArg$XAxisFeatName <- c(12, 13)
init <- DataFrame(
    Name = paste("Feature assay plot", 1:2),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg)

## ----character-integer--------------------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 2)
fexArg$DataBoxOpen <- TRUE
fexArg$Assay <- c(6, "counts")
init <- DataFrame(
    Name = paste("Feature assay plot", 1:2),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg)

## ----character----------------------------------------------------------------
fexArg <- featAssayPlotDefaults(sce, 2)
fexArg$DataBoxOpen <- TRUE
fexArg$Assay <- c("logcounts", "counts")
fexArg$YAxisFeatName <- c("A3galt2", "A4galt")
fexArg$XAxis <- "Feature name"
fexArg$XAxisFeatName <- c("L3mbtl1", "L3mbtl2")
init <- DataFrame(
    Name = paste("Feature assay plot", 1:2),
    Width = c(6, 6)
)
app <- iSEE(sce, initialPanels = init, featAssayArgs = fexArg)

## -----------------------------------------------------------------------------
introtour <- read.delim(
	system.file("extdata/intro_firststeps.txt", package = "iSEE"), 
    sep = ";", header = TRUE)
head(introtour)

## ----sessioninfo--------------------------------------------------------------
sessionInfo()
# devtools::session_info()

