/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.job;

import edu.rit.mp.BooleanBuf;
import edu.rit.mp.Buf;
import edu.rit.mp.buf.BooleanItemBuf;
import edu.rit.pj.Comm;
import edu.rit.pj.WorkerIteration;
import edu.rit.pj.WorkerRegion;
import edu.rit.pj.WorkerTeam;
import edu.rit.pj.job.Job;
import edu.rit.pj.job.JobGenerator;
import edu.rit.util.Instance;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Scanner;

public class Runner {
    private static PrintStream stdout = System.out;
    private static PrintStream stderr = System.err;
    private static Comm world;
    private static int rank;
    private static WorkerTeam team;
    private static String generatorExpression;
    private static HashSet<Integer> omitted;
    private static JobGenerator generator;

    private Runner() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length != 1) {
            Runner.usage();
        }
        Comm.init(stringArray);
        world = Comm.world();
        rank = world.rank();
        team = new WorkerTeam();
        if (rank == team.masterRank()) {
            omitted = new HashSet();
            object = null;
            try {
                object = new Scanner(new File(stringArray[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object != null) {
                while (((Scanner)object).hasNextLine()) {
                    String string;
                    Scanner scanner = new Scanner(((Scanner)object).nextLine());
                    if (!scanner.hasNext() || !(string = scanner.next()).equals("***") || !scanner.hasNext()) continue;
                    string = scanner.next();
                    if (string.equals("Generator")) {
                        if (!scanner.hasNext() || generatorExpression != null) continue;
                        generatorExpression = scanner.next();
                        continue;
                    }
                    if (!string.equals("Job") || !scanner.hasNextInt()) continue;
                    int n = scanner.nextInt();
                    if (!scanner.hasNext() || !(string = scanner.next()).equals("finished")) continue;
                    omitted.add(n);
                }
                ((Scanner)object).close();
            } else {
                generatorExpression = stringArray[0];
            }
            if (generatorExpression == null) {
                stderr.printf("Runner: No job generator in checkpoint file %s%n", stringArray[0]);
            } else {
                try {
                    generator = (JobGenerator)Instance.newInstance(generatorExpression);
                    stdout.printf("*** Generator %s%n", generatorExpression);
                    generator.omit(omitted);
                }
                catch (Throwable throwable) {
                    stderr.printf("Runner: Could not create job generator %s%n", generatorExpression);
                    throwable.printStackTrace(stderr);
                }
            }
        }
        object = BooleanBuf.buffer(generator != null);
        world.broadcast(team.masterRank(), (Buf)object);
        if (!((BooleanItemBuf)object).item) {
            System.exit(1);
        }
        team.execute(new WorkerRegion(){

            public void run() throws Exception {
                this.execute(generator, new WorkerIteration<Job>(){

                    @Override
                    public void sendTaskInput(Job job, Comm comm, int n, int n2) {
                        stdout.printf("*** Job %d started %s %s%n", job.getJobNumber(), new Date(), job.getDescription());
                    }

                    @Override
                    public void run(Job job) {
                        job.run();
                    }

                    @Override
                    public void receiveTaskOutput(Job job, Comm comm, int n, int n2) {
                        stdout.printf("*** Job %d finished %s%n", job.getJobNumber(), new Date());
                    }
                });
            }
        });
        if (rank == team.masterRank()) {
            stdout.printf("*** All jobs finished%n", new Object[0]);
        }
    }

    private static void usage() {
        stderr.println("Usage: java edu.rit.pj.job.Runner {<generator>|<file>}");
        stderr.println("<generator> = Job generator constructor expression");
        stderr.println("<file> = Checkpoint file name");
        System.exit(1);
    }
}

