/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.mp.ByteBuf;
import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.util.Range;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.util.concurrent.LinkedBlockingQueue;

public class BackendFileInputStream
extends InputStream {
    private JobFrontendRef myJobFrontend;
    private JobBackendRef myJobBackend;
    private LinkedBlockingQueue<Result> myResultQueue = new LinkedBlockingQueue();
    private int ffd;

    BackendFileInputStream(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) {
        this.myJobFrontend = jobFrontendRef;
        this.myJobBackend = jobBackendRef;
    }

    BackendFileInputStream(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef, int n) {
        this.myJobFrontend = jobFrontendRef;
        this.myJobBackend = jobBackendRef;
        this.ffd = n;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        return n == -1 ? -1 : byArray[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.verifyOpen();
        this.myJobFrontend.inputFileRead(this.myJobBackend, this.ffd, n2);
        Result result = this.getResult();
        if (result.readlen > 0) {
            ((JobFrontendProxy)this.myJobFrontend).receive(this.ffd, ByteBuf.sliceBuffer(byArray, new Range(n, n + n2 - 1)));
        }
        return result.readlen;
    }

    public long skip(long l) throws IOException {
        this.verifyOpen();
        if (l < 0L) {
            return 0L;
        }
        this.myJobFrontend.inputFileSkip(this.myJobBackend, this.ffd, l);
        return this.getResult().skiplen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.verifyOpen();
        try {
            this.myJobFrontend.inputFileClose(this.myJobBackend, this.ffd);
            this.getResult();
        }
        finally {
            this.ffd = 0;
        }
    }

    int open(int n, File file) throws IOException {
        this.myJobFrontend.inputFileOpen(this.myJobBackend, n, file);
        this.ffd = this.getResult().ffd;
        return this.ffd;
    }

    private Result getResult() throws IOException {
        try {
            Result result = this.myResultQueue.take();
            if (result.exc != null) {
                throw result.exc;
            }
            return result;
        }
        catch (InterruptedException interruptedException) {
            InterruptedIOException interruptedIOException = new InterruptedIOException("I/O interrupted");
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
    }

    void putResult(int n, int n2, long l, IOException iOException) {
        this.myResultQueue.offer(new Result(n, n2, l, iOException));
    }

    private void verifyOpen() throws IOException {
        if (this.ffd == 0) {
            throw new IOException("File closed");
        }
    }

    private static class Result {
        public int ffd;
        public int readlen;
        public long skiplen;
        public IOException exc;

        public Result(int n, int n2, long l, IOException iOException) {
            this.ffd = n;
            this.readlen = n2;
            this.skiplen = l;
            this.exc = iOException;
        }
    }
}

