/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceTree;

public class FitchParsimony {
    private FitchParsimony() {
    }

    public static int computeScore(DnaSequenceTree dnaSequenceTree) {
        int n = dnaSequenceTree.root();
        FitchParsimony.computeScore(dnaSequenceTree, n);
        return dnaSequenceTree.seq(n).score();
    }

    private static void computeScore(DnaSequenceTree dnaSequenceTree, int n) {
        int n2 = dnaSequenceTree.child1(n);
        int n3 = dnaSequenceTree.child2(n);
        if (n2 == -1) {
            return;
        }
        FitchParsimony.computeScore(dnaSequenceTree, n2);
        FitchParsimony.computeScore(dnaSequenceTree, n3);
        DnaSequence dnaSequence = dnaSequenceTree.seq(n2);
        DnaSequence dnaSequence2 = dnaSequenceTree.seq(n3);
        DnaSequence dnaSequence3 = dnaSequenceTree.seq(n);
        if (dnaSequence3 == null) {
            dnaSequence3 = new DnaSequence(dnaSequence.length());
            dnaSequenceTree.seq(n, dnaSequence3);
        }
        dnaSequence3.setFitchAncestor(dnaSequence, dnaSequence2);
        dnaSequence3.name("" + (dnaSequence3.score() - dnaSequence.score() - dnaSequence2.score()));
    }

    public static int updateScore(DnaSequenceTree dnaSequenceTree, int n, DnaSequence[] dnaSequenceArray) {
        int n2 = 0;
        DnaSequence dnaSequence = dnaSequenceTree.seq(n);
        int n3 = dnaSequenceTree.parent(n);
        while (n3 != -1) {
            int n4 = dnaSequenceTree.child1(n3);
            int n5 = dnaSequenceTree.child2(n3);
            DnaSequence dnaSequence2 = dnaSequenceTree.seq(n4);
            DnaSequence dnaSequence3 = dnaSequenceTree.seq(n5);
            dnaSequence = dnaSequenceArray[n2++];
            dnaSequence.setFitchAncestor(dnaSequence2, dnaSequence3);
            dnaSequenceTree.seq(n3, dnaSequence);
            n3 = dnaSequenceTree.parent(n3);
        }
        return dnaSequence.score();
    }
}

