## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ---- eval=TRUE, echo = FALSE, include=TRUE, message=FALSE, warning=FALSE-----
library(bigPint)
data("soybean_cn_sub")
ret <- plotSM(data=soybean_cn_sub, saveFile = FALSE)
ret[["S1_S2"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, message=FALSE, warning=FALSE-----
data("soybean_cn_sub_metrics")
ret <- plotSM(data=soybean_cn_sub, dataMetrics = soybean_cn_sub_metrics,
  pointColor = "magenta", saveFile = FALSE)
ret[["S1_S2"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, message=FALSE, warning=FALSE-----
soybean_cn_sub_st <- as.data.frame(t(apply(as.matrix(soybean_cn_sub[,-1]), 1, scale)))
soybean_cn_sub_st$ID <- as.character(soybean_cn_sub$ID)
soybean_cn_sub_st <- soybean_cn_sub_st[,c(length(soybean_cn_sub_st), 
  1:length(soybean_cn_sub_st)-1)]
colnames(soybean_cn_sub_st) <- colnames(soybean_cn_sub)
nID <- which(is.nan(soybean_cn_sub_st[,2]))
soybean_cn_sub_st[nID,2:length(soybean_cn_sub_st)] <- 0
ret <- plotSM(data=soybean_cn_sub_st, dataMetrics = soybean_cn_sub_metrics,
  pointColor = "magenta", saveFile = FALSE)
ret[["S1_S2"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList = soybean_cn_sub_metrics[["S1_S2"]][1:5,]$ID
ret <- plotLitre(data = soybean_cn_sub[,c(1:7)], geneList = geneList,
  pointColor = "gold", saveFile = FALSE, pointSize = 2)
ret[["S1_S2_Glyma18g00690.1"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList = soybean_cn_sub_metrics[["S1_S2"]][7327:7332,]$ID
ret <- plotLitre(data = soybean_cn_sub[,c(1:7)], geneList = geneList,
  pointColor = "gold", saveFile = FALSE, pointSize = 2)
ret[["S1_S2_Glyma05g34410.3"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList = soybean_cn_sub_metrics[["S1_S2"]][1:5,]$ID
ret <- plotLitre(data = soybean_cn_sub_st[,c(1:7)], geneList = geneList,
  pointColor = "gold", saveFile = FALSE, pointSize = 3)
ret[["S1_S2_Glyma18g00690.1"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList = soybean_cn_sub_metrics[["S1_S2"]][7327:7332,]$ID
ret <- plotLitre(data = soybean_cn_sub_st[,c(1:7)], geneList = geneList,
  pointColor = "gold", saveFile = FALSE, pointSize = 3)
ret[["S1_S2_Glyma05g34410.3"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotPCP(data = soybean_cn_sub_st, dataMetrics = soybean_cn_sub_metrics, 
  saveFile = FALSE, lineSize = 0.5)
ret[["S1_S2"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
geneList <- tail(soybean_cn_sub_metrics[["S1_S2"]], 16)$ID
ret <- plotPCP(data = soybean_cn_sub_st, geneList = geneList, saveFile = FALSE, 
  lineSize = 0.5)
ret[["S1_S2"]]

## ---- eval=TRUE, echo = FALSE, include=TRUE, message=FALSE, warning=FALSE, fig.width = 7.2916667, fig.asp= 1/1.618----
ret <- plotVolcano(data = soybean_cn_sub, dataMetrics = soybean_cn_sub_metrics, 
  saveFile = FALSE, pointSize = 3, pointColor = "red")
ret[["S1_S2"]]

