## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo=TRUE)

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
library(grid)
library(matrixStats)
library(ggplot2)
library(bigPint)
data("soybean_ir_sub")
data("soybean_ir_sub_metrics")
soybean_ir_sub[,-1] <- log(soybean_ir_sub[,-1]+1)
nrow(soybean_ir_sub)
length(which(soybean_ir_sub_metrics[["N_P"]]$FDR < 1e-7))

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
colList = c("#00A600FF", rainbow(5)[c(1,4,5)])
ret <- plotClusters(data=soybean_ir_sub, dataMetrics = soybean_ir_sub_metrics, nC=4,
  colList = colList, clusterAllData = FALSE, threshVal = 1e-7, saveFile = FALSE)
names(ret)
grid.draw(ret[["N_P_4"]])

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotClusters(data=soybean_ir_sub, dataMetrics = soybean_ir_sub_metrics, nC=4,
  colList = colList, clusterAllData = TRUE, threshVal = 1e-7, saveFile = FALSE)
grid.draw(ret[["N_P_4"]])

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotClusters(data=soybean_ir_sub, nC=4, colList = colList,
  clusterAllData = TRUE, saveFile = FALSE)
grid.draw(ret[["N_P_4"]])

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
data(soybean_cn_sub)
data(soybean_cn_sub_metrics)
soybean_cn_sub_st <- as.data.frame(t(apply(as.matrix(soybean_cn_sub[,-1]), 1, 
  scale)))
soybean_cn_sub_st$ID <- as.character(soybean_cn_sub$ID)
soybean_cn_sub_st <- soybean_cn_sub_st[,c(length(soybean_cn_sub_st), 
  1:length(soybean_cn_sub_st)-1)]
colnames(soybean_cn_sub_st) <- colnames(soybean_cn_sub)
nID <- which(is.nan(soybean_cn_sub_st[,2]))
soybean_cn_sub_st[nID,2:length(soybean_cn_sub_st)] <- 0
ret <- plotClusters(data=soybean_cn_sub_st, dataMetrics = soybean_cn_sub_metrics, 
  nC=4, colList = c("#00A600FF", "#CC00FFFF", "red", "darkorange"), lineSize = 0.5, 
  lineAlpha = 1, clusterAllData = FALSE, aggMethod = "average",
  yAxisLabel = "Standardized read count", saveFile = FALSE)
names(ret)
grid.draw(ret[["S1_S2_4"]])
grid.draw(ret[["S1_S3_4"]])

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  plotClusters(data=soybean_cn_sub_st, dataMetrics = soybean_cn_sub_metrics, nC=4,
#    colList = c("#00A600FF", "#CC00FFFF", "red", "darkorange"), lineSize = 0.5,
#    lineAlpha = 1, clusterAllData = FALSE, aggMethod = "average",
#    yAxisLabel = "Standardized read count", verbose = TRUE)

## ---- eval=TRUE, include=FALSE, message=FALSE, warning=FALSE------------------
S1S3Cluster1 <- c("Glyma18g00690.1", "Glyma08g44110.1", "Glyma01g26570.1", "Glyma07g09700.1", "Glyma02g40610.1", "Glyma17g17970.1", "Glyma19g26250.1", "Glyma10g34630.1", "Glyma14g14220.1", "Glyma19g26710.1", "Glyma03g29150.1", "Glyma08g19245.1", "Glyma07g01730.2", "Glyma18g25845.1", "Glyma08g22380.1", "Glyma20g30460.1", "Glyma12g10960.1", "Glyma16g08810.1", "Glyma18g42630.2")

## ---- eval=TRUE, include=FALSE, message=FALSE, warning=FALSE------------------
S1S3Cluster2 <- c("Glyma06g12670.1", "Glyma12g32460.1", "Glyma17g09850.1", "Glyma18g52920.1", "Glyma01g24710.1", "Glyma04g39880.1", "Glyma05g27450.2")

## ---- eval=TRUE, include=FALSE, message=FALSE, warning=FALSE------------------
S1S3Cluster3 <- c("Glyma04g37510.1", "Glyma03g19880.1")

## ---- eval=TRUE, include=FALSE, message=FALSE, warning=FALSE------------------
S1S3Cluster4 <- c("Glyma08g11570.1", "Glyma08g19290.1")

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  S1S3Cluster1 <- readRDS(paste0(tempdir(), "/S1_S3_4_1.rds"))

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
S1S3Cluster1

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotSM(data = soybean_cn_sub_st, geneList = S1S3Cluster1,
  pointColor = "#00A600FF", saveFile = FALSE)
ret[["S1_S3"]] + ggtitle("Cluster 1 Genes (n=19)")

## ---- eval=FALSE, include=TRUE, message=FALSE, warning=FALSE------------------
#  S1S3Cluster2 <- readRDS(paste0(tempdir(), "/S1_S3_4_2.rds"))
#  S1S3Cluster3 <- readRDS(paste0(tempdir(), "/S1_S3_4_3.rds"))
#  S1S3Cluster4 <- readRDS(paste0(tempdir(), "/S1_S3_4_4.rds"))

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
S1S3Cluster2
S1S3Cluster3
S1S3Cluster4

## ---- eval=TRUE, include=TRUE, message=FALSE, warning=FALSE-------------------
ret <- plotClusters(data=soybean_cn_sub_st, geneLists = list(S1S3Cluster2,
  S1S3Cluster3, S1S3Cluster4), lineAlpha = 1, lineSize = 0.5)
grid.draw(ret[["S1_S3_3"]])

