## ----options, eval=TRUE, echo=FALSE----------------------------------------
options(showHeadLines=3)
options(showTailLines=3)

## ----Load, message=FALSE---------------------------------------------------
library(VariantExperiment)

## ----makeVariantExperimentFromVCF------------------------------------------
vcf <- SeqArray::seqExampleFileName("vcf")
ve <- makeVariantExperimentFromVCF(vcf)
ve

## ----retrieve GDS----------------------------------------------------------
gdsfile(ve)

## ----makeVariantExperimentFromVCF2-----------------------------------------
assay(ve, 1)

## ----makeVariantExperimentFromVCF3-----------------------------------------
rowData(ve)

## ----sampleInfo------------------------------------------------------------
sampleInfo <- system.file("extdata", "Example_sampleInfo.txt",
                          package="VariantExperiment")
ve <- makeVariantExperimentFromVCF(vcf, sample.info = sampleInfo)
colData(ve)

## ----makeVariantExperimentFromVCFArgs--------------------------------------
ve1 <- makeVariantExperimentFromVCF(vcf, info.import=c("OR", "GP"))
rowData(ve1)

## ----makeVariantExperimentFromVCFArgs_startCount---------------------------
ve2 <- makeVariantExperimentFromVCF(vcf, start=101, count=1000)
ve2

## ----makeVariantExperimentFromGDS------------------------------------------
gds <- SeqArray::seqExampleFileName("gds")
ve <- makeVariantExperimentFromGDS(gds)
ve

## ----makeVariantExperimentFromGDS2-----------------------------------------
rowData(ve)
colData(ve)

## ----showAvailable---------------------------------------------------------
showAvailable(gds)

## ----makeVariantExperimentFromGDSArgs--------------------------------------
ve3 <- makeVariantExperimentFromGDS(gds,
                                    rowDataColumns = c("ID", "ALT", "REF"),
                                    infoColumns = c("AC", "AN", "DP"),
                                    rowDataOnDisk = TRUE,
                                    colDataOnDisk = FALSE)
rowData(ve3)  ## DelayedDataFrame object 
colData(ve3)  ## DataFrame object

## ----stats-----------------------------------------------------------------
## sample missing rate
mr.samp <- seqMissing(ve, per.variant = FALSE)
head(mr.samp)
## hwe
hwe <- hwe(ve)
head(hwe)
## titv ratio by sample / overall
titv <- titv(ve, by.sample=TRUE)
head(titv)
titv(ve, by.sample=FALSE)
## countSingletons
countSingletons(ve)

## ----sessionInfo-----------------------------------------------------------
sessionInfo()

