## ----options, eval=TRUE, echo=FALSE----------------------------------------
options(showHeadLines=3)
options(showTailLines=3)

## ----getPackage, eval=FALSE------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("VariantExperiment")

## ---- eval = FALSE---------------------------------------------------------
#  BiocManager::install(“Bioconductor/VariantExperiment”)

## ----Load, message=FALSE---------------------------------------------------
library(VariantExperiment)

## ---- GDSArray-------------------------------------------------------------
gds <- SeqArray::seqExampleFileName("gds")
GDSArray(gds, "genotype/data")
GDSArray(gds, "sample.id")

## ----makeVariantExperimentFromGDS------------------------------------------
ve <- makeVariantExperimentFromGDS(gds)
ve

## ----makeVariantExperimentFromGDS2-----------------------------------------
assays(ve)
assay(ve, 1)

## ----rrrd------------------------------------------------------------------
rowRanges(ve)
rowData(ve)

## ----colData---------------------------------------------------------------
colData(ve)

## ----gdsfile---------------------------------------------------------------
gdsfile(ve)

## ----metaData--------------------------------------------------------------
metadata(ve)

## ---- 2d-------------------------------------------------------------------
ve[1:10, 1:5]

## ----colDataExtraction-----------------------------------------------------
colData(ve)
ve[, as.logical(ve$family == "1328")]

## ----rowDataExtraction-----------------------------------------------------
rowData(ve)
ve[as.logical(rowData(ve)$REF == "T"),]

## ----overlap---------------------------------------------------------------
ve1 <- subsetByOverlaps(ve, GRanges("22:1-48958933"))
ve1

## ----saveLoad, eval=FALSE--------------------------------------------------
#  hwe(ve1)
#  ## Error in .saveGDSMaybe(gdsfile) : use
#  ##   'saveVariantExperiment()' to synchronize on-disk and
#  ##   in-memory representations

## ----saveVE----------------------------------------------------------------
a <- tempfile()
ve2 <- saveVariantExperiment(ve1, dir=a, replace=TRUE)

## ----loadVE----------------------------------------------------------------
ve3 <- loadVariantExperiment(dir=a)
gdsfile(ve3)
all.equal(ve2, ve3)

## ----newVEstats------------------------------------------------------------
head(hwe(ve2))

## ----sessionInfo-----------------------------------------------------------
sessionInfo()

