## ----style, echo = FALSE, results = 'asis'---------------------------------
BiocStyle::markdown(css.files = c('custom.css'))

## ----package, echo=FALSE---------------------------------------------------
suppressPackageStartupMessages({
  library(Structstrings)
})

## ----package2, eval=FALSE--------------------------------------------------
#  if(!requireNamespace("BiocManager", quietly = TRUE))
#  	install.packages("BiocManager")
#  BiocManager::install("Structstrings")
#  library(Structstrings)

## ----annotation_convert----------------------------------------------------
dbs[[2]] <- convertAnnotation(dbs[[2]],from = 2L, to = 1L)
dbs[[3]] <- convertAnnotation(dbs[[3]],from = 3L, to = 1L)
dbs[[4]] <- convertAnnotation(dbs[[4]],from = 4L, to = 1L)
# Note: convertAnnotation checks for presence of annotation and stops
# if there is any conflict.
dbs

## ----base_pairing----------------------------------------------------------
# base pairing table
dbdfl <- getBasePairing(dbs)
dbdfl[[1]]

## ----loopindices-----------------------------------------------------------
loopids <- getLoopIndices(dbs, bracket.type = 1L)
loopids[[1]]
# can also be constructed from DotBracketDataFrame and contains the same 
# information
loopids2 <- getLoopIndices(dbdfl, bracket.type = 1L)
all(loopids == loopids2)

## ----dotbracket------------------------------------------------------------
rec_dbs <- getDotBracket(dbdfl)
dbdf <- unlist(dbdfl)
dbdf$character <- NULL
dbdfl2 <- relist(dbdf,dbdfl)
# even if the character column is not set, the dot bracket string can be created
rec_dbs2 <- getDotBracket(dbdfl2)
rec_dbs3 <- getDotBracket(dbdfl, force = TRUE)
rec_dbs[[1]]
rec_dbs2[[1]]
rec_dbs3[[1]]

## ----pseudoloop------------------------------------------------------------
db <- DotBracketString("((((....[[[))))....((((....<<<<...))))]]]....>>>>...")
db
getDotBracket(getBasePairing(db), force = TRUE)

## ----structured_rna_string-------------------------------------------------
data("dbs", package = "Structstrings", envir = environment())
data("seq", package = "Structstrings", envir = environment())
sdbs <- StructuredRNAStringSet(seq,dbs)
sdbs[1]
# subsetting to element returns the sequence
sdbs[[1]]
# dotbracket() gives access to the DotBracketStringSet
dotbracket(sdbs)[[1]]

## ----structured_rna_string_base_pairing------------------------------------
dbdfl <- getBasePairing(sdbs)
dbdfl[[1]]
# returns the result without sequence information
dbdfl <- getBasePairing(sdbs, return.sequence = TRUE)
dbdfl[[1]]

## --------------------------------------------------------------------------
sessionInfo()

