## ---- message=FALSE--------------------------------------------------------
library(M3C)
library(NMF) 
library(gplots)
library(ggsci)
# now we have loaded the mydata and desx objects (with the package automatically)
# mydata is the expression data for GBM
# desx is the annotation for this data

## ---- message=FALSE, results='hide'----------------------------------------
PCA1 <- pca(mydata)

## ---- message=FALSE, results='hide'----------------------------------------
# for vignette
res <- M3C(mydata, cores=1, seed = 123, des = desx, removeplots = TRUE, 
           analysistype = 'chi', doanalysis = TRUE, variable = 'class')

# basic usage
# res <- M3C(mydata)

## --------------------------------------------------------------------------
res$scores

## --------------------------------------------------------------------------
res$clinicalres

## ----fig.show = 'hide'-----------------------------------------------------
# get the data out of the results list (by using $ - dollar sign) for K=4
data <- res$realdataresults[[4]]$ordered_data # this is the data
annon <- res$realdataresults[[4]]$ordered_annotation # this is the annotation
ccmatrix <- res$realdataresults[[4]]$consensus_matrix # this is the consensus matrix
head(annon)

## ----fig.show = 'hide'-----------------------------------------------------
data <- t(scale(t(data))) # z-score normalise each row
data <- apply(data, 2, function(x) ifelse(x > 4, 4, x)) # compress data 
data <- apply(data, 2, function(x) ifelse(x < -4, -4, x)) # compress data

ann_colors <- ggsci::pal_startrek("uniform")(4)
ann_colors2 <- ggsci::pal_futurama()(4) #
pal <- rev(colorRampPalette(RColorBrewer::brewer.pal(10, "RdBu"))(256))
NMF::aheatmap(data, annCol = annon, Colv = NA, distfun = 'pearson', 
         color = gplots::bluered(256), 
         annColors = list(class=ann_colors, consensuscluster=ann_colors2))


## ----fig.show = 'hide'-----------------------------------------------------
# set up colours
n <- 10
seq = rev(seq(0,255,by=255/(n)))
palRGB = cbind(seq,seq,255)
mypal <-rgb(palRGB,maxColorValue=255)
# plot consensus matrix heatmap, do not cluster rows and columns
NMF::aheatmap(ccmatrix, 
              annCol = annon[,1,drop=FALSE], 
              color = mypal, scale = 'none', cexRow = 0, cexCol = 0,
              Colv=NA,Rowv=NA,annColors = list(consensuscluster=ann_colors2))

## ----fig.show = 'hide',message=FALSE,results='hide'------------------------
  PCA2 <- pca(res, K=4)
  TSNE <- tsne(res, K=4, perplex=15)

## ----fig.show = 'hide',message=FALSE,results='hide'------------------------
res <- M3C(mydata, method = 2)

## ----fig.show = 'hide',message=FALSE,results='hide'------------------------
  res <- clustersim(225, 900, 8, 4, 0.75, 0.025, print = FALSE, seed=123)

## --------------------------------------------------------------------------
  filtered_results <- featurefilter(mydata, percentile=10, method='MAD', topN=5)

