/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions;

import com.install4j.api.actions.AutoUninstallAction;
import com.install4j.api.context.ProgressInterface;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.runtime.beans.AutoUninstallHandler;
import com.install4j.runtime.beans.actions.SystemUninstallAction;
import com.install4j.runtime.installer.config.InstallerConfig;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.helper.ServiceHandler;
import com.install4j.runtime.installer.helper.fileinst.FileInstaller;
import com.install4j.runtime.installer.helper.registry.InstallRegistry;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;

public class UninstallFilesAction
extends SystemUninstallAction {
    public boolean uninstall(UninstallerContext uninstallerContext) throws UserCanceledException {
        ServiceHandler.stopServices(uninstallerContext, false);
        String string = MessageFormat.format(uninstallerContext.getMessage("StatusUninstalling"), InstallerConfig.getCurrentInstance().getApplicationNameWithVersion());
        ProgressInterface progressInterface = uninstallerContext.getProgressInterface();
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(string);
        if (!RunningProcessChecker.checkRunningProcesses(uninstallerContext, "UninstallAppRunningError", false)) {
            throw new UserCanceledException();
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(string);
        if (!this.executeAutoUninstallActions(uninstallerContext)) {
            return false;
        }
        progressInterface.setDetailMessage("");
        progressInterface.setStatusMessage(string);
        InstallerConfig installerConfig = InstallerConfig.getCurrentInstance();
        InstallRegistry.unregisterApplication(installerConfig.getApplicationId(), uninstallerContext.getInstallationDirectory());
        FileInstaller fileInstaller = FileInstaller.getInstance();
        try {
            Iterator iterator = installerConfig.getUninstallDeleteEntries().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                fileInstaller.deleteFile(uninstallerContext.getDestinationFile(string2));
            }
            fileInstaller.uninstall(progressInterface, uninstallerContext.isUninstallForUpgrade());
        }
        catch (IOException iOException) {
            uninstallerContext.handleCriticalException(iOException);
        }
        if (!InstallerUtil.isWindows() && !InstallerUtil.isMacOS()) {
            try {
                Runtime.getRuntime().exec("kbuildsycoca");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (InstallerUtil.isMacOS()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return true;
    }

    private boolean executeAutoUninstallActions(UninstallerContext uninstallerContext) {
        try {
            List list = AutoUninstallHandler.getAutoUninstallActions(uninstallerContext.getDestinationFile(".install4j"));
            for (int i = 0; i < list.size(); ++i) {
                AutoUninstallAction autoUninstallAction = (AutoUninstallAction)list.get(i);
                Logger.getInstance().info(autoUninstallAction, "executing auto uninstall");
                try {
                    if (autoUninstallAction.uninstall(uninstallerContext)) continue;
                    return false;
                }
                catch (UserCanceledException userCanceledException) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }
}

