## ----setup,echo = FALSE, include = TRUE----------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----load_packages, message=FALSE, warning=FALSE, include=FALSE----------
library(GNET2)

## ----echo = TRUE---------------------------------------------------------
set.seed(2)
init_group_num = 8
init_method = 'boosting'
exp_data <- matrix(rnorm(600*12),600,12)
reg_names <- paste0('TF',1:20)
rownames(exp_data) <- c(reg_names,paste0('gene',1:(nrow(exp_data)-length(reg_names))))
colnames(exp_data) <- paste0('condition_',1:ncol(exp_data))
se <- SummarizedExperiment::SummarizedExperiment(assays=list(counts=exp_data))

## ---- echo=TRUE----------------------------------------------------------
gnet_result <- gnet(se,reg_names,init_method,init_group_num,heuristic = TRUE)

## ---- echo=TRUE,fig.width=10, fig.height=12------------------------------
plot_gene_group(gnet_result,group_idx = 1)

## ---- echo=TRUE,fig.width=8, fig.height=8--------------------------------
plot_tree(gnet_result,group_idx = 1)

## ---- echo=TRUE,fig.width=8, fig.height=8--------------------------------
group_above_kn <- plot_group_correlation(gnet_result)
print(group_above_kn)

## ---- echo=TRUE----------------------------------------------------------
sessionInfo()

