/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.hyb.prime;

import edu.rit.hyb.prime.LongIterator;
import java.io.IOException;

public class Sieve {
    private boolean[] isPrime;
    private long lb;
    private int len;
    private long p0;
    private long p1;
    private long p2;
    private long p3;
    private long p4;
    private long p5;
    private long p6;
    private long p7;
    private long p8;
    private long p9;
    private long pa;
    private long pb;
    private long pc;
    private long pd;
    private long pe;
    private long pf;

    public Sieve(long l, int n) {
        this.isPrime = new boolean[n + 128];
        this.lb = l;
        this.len = n;
    }

    public long lb() {
        return this.lb;
    }

    public void lb(long l) {
        this.lb = l;
    }

    public long length() {
        return this.len;
    }

    public void len(int n) {
        this.isPrime = new boolean[n + 128];
        this.len = n;
    }

    public void initialize() {
        for (int i = 1; i < this.len; i += 2) {
            this.isPrime[i] = true;
        }
        if (this.lb == 0L) {
            this.isPrime[1] = false;
        }
    }

    public boolean sieveOut(long l) {
        long l2 = l * l;
        if (l2 - this.lb >= (long)this.len) {
            return false;
        }
        long l3 = (this.lb + l - 1L) / l;
        if ((l3 & 1L) == 0L) {
            ++l3;
        }
        long l4 = l3 * l;
        l4 = Math.max(l4, l2);
        long l5 = 2L * l;
        for (long i = l4 - this.lb; i < (long)this.len; i += l5) {
            this.isPrime[(int)i] = false;
        }
        return true;
    }

    public void sieveOut(LongIterator longIterator) throws IOException {
        long l;
        this.initialize();
        while ((l = longIterator.next()) != 0L && this.sieveOut(l)) {
        }
    }

    public boolean isPrime(long l) {
        return this.isPrime[(int)(l - this.lb)];
    }

    public LongIterator iterator() {
        return new LongIterator(){
            private int i = 0;
            private long p0;
            private long p1;
            private long p2;
            private long p3;
            private long p4;
            private long p5;
            private long p6;
            private long p7;
            private long p8;
            private long p9;
            private long pa;
            private long pb;
            private long pc;
            private long pd;
            private long pe;
            private long pf;

            public long next() {
                do {
                    ++this.i;
                } while (this.i < Sieve.this.len && !Sieve.this.isPrime[this.i]);
                return this.i < Sieve.this.len ? Sieve.this.lb + (long)this.i : 0L;
            }

            public void close() {
            }
        };
    }
}

