## --------------------------------------------------------------------------
library(BridgeDbR)

## --------------------------------------------------------------------------
code = getOrganismCode("Rattus norvegicus")
code

## --------------------------------------------------------------------------
fullName <- getFullName("Ce")
fullName
code <- getSystemCode("ChEBI")
code

## --------------------------------------------------------------------------
getMatchingSources("HMDB00555")
getMatchingSources("ENSG00000100030")

## --------------------------------------------------------------------------
getBridgeNames()

## ---- eval=FALSE-----------------------------------------------------------
#  dbLocation <- getDatabase("Rattus norvegicus",location=getwd())

## ---- eval=FALSE-----------------------------------------------------------
#  mapper <- loadDatabase(dbLocation)

## ---- eval=FALSE-----------------------------------------------------------
#  location <- getDatabase("Homo sapiens")
#  mapper <- loadDatabase(location)
#  map(mapper, "L", "196410", "X")

## ---- eval=FALSE-----------------------------------------------------------
#  mapToSingle = function(x) {
#    mappings = map(mapper, "Ch", x, "Wd")
#    if (length(mappings) == 1) {
#      result = mappings
#    } else {
#      result = mappings[1]
#    }
#    return(result)
#  }

## ---- eval=FALSE-----------------------------------------------------------
#  wikidata = unlist(sapply(as.character(data[,2]), mapToSingle))
#  data2 = cbind(c(wikidata,""),data)

## ---- eval=FALSE-----------------------------------------------------------
#  file <- "metabolites_20180201.bridge"
#  download.file(
#    "https://ndownloader.figshare.com/files/10358973",
#    location
#  )
#  location = normalizePath(file)
#  mapper <- loadDatabase(location)

## ---- eval=FALSE-----------------------------------------------------------
#  map(mapper, "456", source="Cs", target="Ck")

