/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bridgedb.DataSource;
import org.bridgedb.Xref;

public enum Organism {
    AnophelesGambiae("Anopheles gambiae", "Ag", "Mosquito", 7165),
    ArabidopsisThaliana("Arabidopsis thaliana", "At", 3702),
    Aspergillusniger("Aspergillus niger", "An", "Black mold", 5061),
    BrachypodiumDistachyon("Brachypodium distachyon", "Bd", 15368),
    BacillusSubtilis("Bacillus subtilis", "Bs", 1423),
    BetaVulgaris("Beta vulgaris", "Bv", "Sugar Beet", 3555),
    BosTaurus("Bos taurus", "Bt", "Cow", 9913),
    CaenorhabditisElegans("Caenorhabditis elegans", "Ce", "Worm", 6239),
    CanisFamiliaris("Canis familiaris", "Cf", "Dog", 9615),
    CionaIntestinalis("Ciona intestinalis", "Ci", "Sea Squirt", 7719),
    Clostridiumthermocellum("Clostridium thermocellum", "Ct", "Cthe", 1515),
    DanioRerio("Danio rerio", "Dr", "Zebra fish", 7955),
    DasypusNovemcinctus("Dasypus novemcinctus", "Dn", "Armadillo", 9361),
    DrosophilaMelanogaster("Drosophila melanogaster", "Dm", "Fruit fly", 7227),
    EscherichiaColi("Escherichia coli", "Ec", 562),
    EchinposTelfairi("Echinops telfairi", "Et", "Hedgehog", 9371),
    EquusCaballus("Equus caballus", "Qc", "Horse", 9796),
    GallusGallus("Gallus gallus", "Gg", "Chicken", 9031),
    GlycineMax("Glycine max", "Gm", "Soybean", 3847),
    GibberellaZeae("Gibberella zeae", "Gz", "Fusarium graminearum", 5518),
    HomoSapiens("Homo sapiens", "Hs", "Human", 9606),
    HordeumVulgare("Hordeum vulgare", "Hv", "Barley", 4513),
    LoxodontaAfricana("Loxodonta africana", "La", "Elephant", 9785),
    MacacaMulatta("Macaca mulatta", "Ml", "Rhesus Monkey", 9544),
    MusMusculus("Mus musculus", "Mm", "Mouse", 10090),
    MonodelphisDomestica("Monodelphis domestica", "Md", "Opossum", 13616),
    MycobacteriumTuberculosis("Mycobacterium tuberculosis", "Mx", "Tuberculosis", 1773),
    OrnithorhynchusAnatinus("Ornithorhynchus anatinus", "Oa", "Platypus", 9258),
    OryzaSativa("Oryza sativa", "Os", "Rice", 4530),
    OryzaJaponica("Oryza japonica", "Oj", "Rice"),
    OryzaSativaJaponica("Oryza sativa Japonica Group", "Osj", "Rice", 39947),
    OryzaIndica("Oryza indica", "Oi", "Indian Rice"),
    OryzaSativaIndica("Oryza sativa Indica Group", "Osi", "Indian Rice", 39946),
    OryziasLatipes("Oryzias latipes", "Ol", "Medaka Fish", 8090),
    OryctolagusCuniculus("Oryctolagus cuniculus", "Oc", "Rabbit", 9986),
    PanTroglodytes("Pan troglodytes", "Pt", "Chimpanzee", 9598),
    PlasmodiumFalciparum("Plasmodium falciparum", "Pf", "Malaria Parasite", 5833),
    PopulusTrichocarpa("Populus trichocarpa", "Pi", "Western Balsam Poplar", 3694),
    RattusNorvegicus("Rattus norvegicus", "Rn", "Rat", 10116),
    SaccharomycesCerevisiae("Saccharomyces cerevisiae", "Sc", "Yeast", 4932),
    SolanumLycopersicum("Solanum lycopersicum", "Sl", "Tomato", 4081),
    SorexAraneus("Sorex araneus", "Sa", "Shrew", 42254),
    SusScrofa("Sus scrofa", "Ss", "Pig", 9823),
    SorghumBicolor("Sorghum bicolor", "Sb", "Sorghum", 4558),
    TetraodonNigroviridis("Tetraodon nigroviridis", "Tn", "Pufferfish", 99883),
    TriticumAestivum("Triticum aestivum", "Ta", "Wheat", 4565),
    XenopusTropicalis("Xenopus tropicalis", "Xt", "Frog", 8364),
    VitisVinifera("Vitis vinifera", "Vv", "Wine Grape", 29760),
    ZeaMays("Zea mays", "Zm", "Maize", 4577);

    private String latinName;
    private String code;
    private String shortName;
    private Xref taxonomyID;
    private static Map<Integer, Organism> byTaxonomyID;
    private static Map<String, Organism> byCode;
    private static Map<String, Organism> byLatinName;
    private static Map<String, Organism> byShortName;
    private static List<String> latinNames;
    private static String[] codes;

    private Organism(String latinName, String code) {
        this(latinName, code, latinName);
    }

    private Organism(String latinName, String code, String shortName) {
        this(latinName, code, shortName, -1);
    }

    private Organism(String latinName, String code, int taxonomyRef) {
        this(latinName, code, latinName, taxonomyRef);
    }

    private Organism(String latinName, String code, String shortName, int taxonomyRef) {
        this.latinName = latinName;
        this.code = code;
        this.shortName = shortName;
        if (taxonomyRef > 0) {
            DataSource taxonomyDS = DataSource.fullNameExists((String)"NCBI Taxonomy Database") ? DataSource.getExistingByFullName((String)"NCBI Taxonomy Database") : DataSource.register((String)"Tn", (String)"NCBI Taxonomy Database").asDataSource();
            this.taxonomyID = new Xref("" + taxonomyRef, taxonomyDS);
        }
    }

    public String code() {
        return this.code;
    }

    public String latinName() {
        return this.latinName;
    }

    public String shortName() {
        return this.shortName;
    }

    public Xref taxonomyID() {
        return this.taxonomyID;
    }

    public static Organism fromTaxonomyId(int taxid) {
        if (byTaxonomyID == null) {
            Organism.initMappings();
        }
        return byTaxonomyID.get(taxid);
    }

    public static Organism fromCode(String code) {
        if (byCode == null) {
            Organism.initMappings();
        }
        return byCode.get(code);
    }

    public static Organism fromShortName(String shortName) {
        if (byShortName == null) {
            Organism.initMappings();
        }
        return byShortName.get(shortName);
    }

    public static List<String> latinNames() {
        if (latinNames == null) {
            Organism.initMappings();
        }
        return latinNames;
    }

    public static String[] codes() {
        if (codes == null) {
            Organism.initMappings();
        }
        return codes;
    }

    public static String[] latinNamesArray() {
        String[] nms = new String[Organism.latinNames().size()];
        return latinNames.toArray(nms);
    }

    public static Organism fromLatinName(String latinName) {
        if (byLatinName == null) {
            Organism.initMappings();
        }
        return byLatinName.get(latinName);
    }

    private static void initMappings() {
        byTaxonomyID = new HashMap<Integer, Organism>();
        byCode = new HashMap<String, Organism>();
        byLatinName = new HashMap<String, Organism>();
        byShortName = new HashMap<String, Organism>();
        for (Organism o : Organism.values()) {
            if (o.taxonomyID() != null) {
                byTaxonomyID.put(Integer.valueOf(o.taxonomyID().getId()), o);
            }
            byCode.put(o.code, o);
            byLatinName.put(o.latinName, o);
            byShortName.put(o.shortName, o);
        }
        latinNames = new ArrayList<String>(byLatinName.keySet());
        Collections.sort(latinNames);
        codes = new String[Organism.latinNames().size()];
        String[] latinNames = Organism.latinNamesArray();
        for (int i = 0; i < latinNames.length; ++i) {
            Organism.codes[i] = Organism.fromLatinName((String)latinNames[i]).code;
        }
    }
}

