\name{MafDb.ESP6500SI.V2.SSA137.dbSNP138-package}
\alias{MafDb.ESP6500SI.V2.SSA137.dbSNP138-package}
\alias{MafDb.ESP6500SI.V2.SSA137.dbSNP138}
\docType{package}

\title{
Annotation package for minimum allele frequency data from the NHLBI ESP project
}
\description{
This annotation package stores minimum allele frequency (MAF) data values frozen from the NHLBI Exome Sequencing (ESP) project. The data is stored in the form of a SQLite database and is loaded automatically in the form of a MafDb object. The name of the exposed object matches the name of the package and part of the filename that contained the data imported into the package. The class definition and methods to access MafDb objects are found in the \code{\link[VariantFiltering]{VariantFiltering}} software package.
}

\format{
  \tabular{ll}{
    \code{\link{MafDb.ESP6500SI.V2.SSA137.dbSNP138}} \tab MafDb object containing MAF values from 6500 ESP exomes downloaded in October 2013 from \url{http://evs.gs.washington.edu/evs_bulk_data/ESP6500SI-V2-SSA137.dbSNP138-rsIDs.snps_indels.vcf.tar.gz}. See \code{\link{makeMafDbPackageESP}} for more information on how to update these data. \cr
  }
}

\author{
R. Castelo & D. Elurbe
}

\seealso{
  \link{makeMafDbPackageESP}
  \link[MafDb.ALL.wgs.phase1.release.v3.20101123]{MafDb.ALL.wgs.phase1.release.v3.20101123}
  \link[VariantFiltering]{MafDb-class}
  \link[VariantFiltering]{fetchKnownVariantsByID}
  \link[VariantFiltering]{VariantFiltering}
}

\examples{
library(MafDb.ESP6500SI.V2.SSA137.dbSNP138)

ls("package:MafDb.ESP6500SI.V2.SSA137.dbSNP138")

MafDb.ESP6500SI.V2.SSA137.dbSNP138
}

\source{
  Exome Variant Server, NHLBI GO Exome Sequencing Project (ESP), Seattle, WA
  (URL: \url{http://evs.gs.washington.edu/EVS}) [October, 2013, accessed]
}

\keyword{package}
\keyword{data}
