datacache <- new.env(hash=TRUE, parent=emptyenv())

yeast2 <- function() showQCData("yeast2", datacache)
yeast2_dbconn <- function() dbconn(datacache)
yeast2_dbfile <- function() dbfile(datacache)
yeast2_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
yeast2_dbInfo <- function() dbInfo(datacache)

yeast2ORGANISM <- "Saccharomyces cerevisiae"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "yeast2.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("YEASTCHIP_DB", "yeast2", "chip yeast2", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("yeast2.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(yeast2_dbconn())
}

