datacache <- new.env(hash=TRUE, parent=emptyenv())

rguatlas4k <- function() showQCData("rguatlas4k", datacache)
rguatlas4k_dbconn <- function() dbconn(datacache)
rguatlas4k_dbfile <- function() dbfile(datacache)
rguatlas4k_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
rguatlas4k_dbInfo <- function() dbInfo(datacache)

rguatlas4kORGANISM <- "Rattus norvegicus"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "rguatlas4k.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("RATCHIP_DB", "rguatlas4k", "chip rguatlas4k", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("rguatlas4k.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(rguatlas4k_dbconn())
}

