
\name{mu19ksubb_dbconn}

\alias{mu19ksubb_dbconn}
\alias{mu19ksubb_dbfile}
\alias{mu19ksubb_dbschema}
\alias{mu19ksubb_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  mu19ksubb_dbconn()
  mu19ksubb_dbfile()
  mu19ksubb_dbschema(file="", show.indices=FALSE)
  mu19ksubb_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{mu19ksubb_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{mu19ksubb_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{mu19ksubb_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{mu19ksubb_dbschema} prints the schema definition of the
  package annotation DB.

  \code{mu19ksubb_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{mu19ksubb_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{mu19ksubb_dbfile}: a character string with the path to the
  package annotation DB.

  \code{mu19ksubb_dbschema}: none (invisible \code{NULL}).

  \code{mu19ksubb_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(mu19ksubb_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by mu19ksubb_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=mu19ksubb_dbfile(), cache_size=64000,
  synchronous=0)

  mu19ksubb_dbschema()

  mu19ksubb_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

