
\name{hu35ksuba_dbconn}

\alias{hu35ksuba_dbconn}
\alias{hu35ksuba_dbfile}
\alias{hu35ksuba_dbschema}
\alias{hu35ksuba_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hu35ksuba_dbconn()
  hu35ksuba_dbfile()
  hu35ksuba_dbschema(file="", show.indices=FALSE)
  hu35ksuba_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hu35ksuba_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hu35ksuba_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hu35ksuba_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hu35ksuba_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hu35ksuba_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hu35ksuba_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hu35ksuba_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hu35ksuba_dbschema}: none (invisible \code{NULL}).

  \code{hu35ksuba_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "probes" table:
  dbGetQuery(hu35ksuba_dbconn(), "SELECT COUNT(*) FROM probes")

  ## The connection object returned by hu35ksuba_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hu35ksuba_dbfile(), cache_size=64000,
  synchronous=0)

  hu35ksuba_dbschema()

  hu35ksuba_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

