\name{hom.Sc.inpHOMSA}
\alias{hom.Sc.inpACYPI}
\alias{hom.Sc.inpAEDAE}
\alias{hom.Sc.inpANOGA}
\alias{hom.Sc.inpAPIME}
\alias{hom.Sc.inpARATH}
\alias{hom.Sc.inpASPFU}
\alias{hom.Sc.inpBATDE}
\alias{hom.Sc.inpBOMMO}
\alias{hom.Sc.inpBOSTA}
\alias{hom.Sc.inpBRAFL}
\alias{hom.Sc.inpBRUMA}
\alias{hom.Sc.inpCAEBRE}
\alias{hom.Sc.inpCAEBR}
\alias{hom.Sc.inpCAEEL}
\alias{hom.Sc.inpCAEJA}
\alias{hom.Sc.inpCAERE}
\alias{hom.Sc.inpCANAL}
\alias{hom.Sc.inpCANGL}
\alias{hom.Sc.inpCANFA}
\alias{hom.Sc.inpCAPSP}
\alias{hom.Sc.inpCAVPO}
\alias{hom.Sc.inpCHLRE}
\alias{hom.Sc.inpCIOIN}
\alias{hom.Sc.inpCIOSA}
\alias{hom.Sc.inpCOCIM}
\alias{hom.Sc.inpCOPCI}
\alias{hom.Sc.inpCRYNE}
\alias{hom.Sc.inpCRYHO}
\alias{hom.Sc.inpCRYPA}
\alias{hom.Sc.inpCULPI}
\alias{hom.Sc.inpCYAME}
\alias{hom.Sc.inpDANRE}
\alias{hom.Sc.inpDAPPU}
\alias{hom.Sc.inpDEBHA}
\alias{hom.Sc.inpDICDI}
\alias{hom.Sc.inpDROAN}
\alias{hom.Sc.inpDROGR}
\alias{hom.Sc.inpDROME}
\alias{hom.Sc.inpDROMO}
\alias{hom.Sc.inpDROPS}
\alias{hom.Sc.inpDROVI}
\alias{hom.Sc.inpDROWI}
\alias{hom.Sc.inpENTHI}
\alias{hom.Sc.inpEQUCA}
\alias{hom.Sc.inpESCCO}
\alias{hom.Sc.inpFUSGR}
\alias{hom.Sc.inpGALGA}
\alias{hom.Sc.inpGASAC}
\alias{hom.Sc.inpGIALA}
\alias{hom.Sc.inpHELRO}
\alias{hom.Sc.inpHOMSA}
\alias{hom.Sc.inpIXOSC}
\alias{hom.Sc.inpKLULA}
\alias{hom.Sc.inpLEIMA}
\alias{hom.Sc.inpLOTGI}
\alias{hom.Sc.inpMACMU}
\alias{hom.Sc.inpMAGGR}
\alias{hom.Sc.inpMONDO}
\alias{hom.Sc.inpMONBR}
\alias{hom.Sc.inpMUSMU}
\alias{hom.Sc.inpNASVI}
\alias{hom.Sc.inpNEMVE}
\alias{hom.Sc.inpNEUCR}
\alias{hom.Sc.inpORNAN}
\alias{hom.Sc.inpORYSA}
\alias{hom.Sc.inpORYLA}
\alias{hom.Sc.inpOSTTA}
\alias{hom.Sc.inpPANTR}
\alias{hom.Sc.inpPEDPA}
\alias{hom.Sc.inpPHYPA}
\alias{hom.Sc.inpPHYRA}
\alias{hom.Sc.inpPHYSO}
\alias{hom.Sc.inpPLAFA}
\alias{hom.Sc.inpPLAVI}
\alias{hom.Sc.inpPONPY}
\alias{hom.Sc.inpPOPTR}
\alias{hom.Sc.inpPRIPA}
\alias{hom.Sc.inpPUCGR}
\alias{hom.Sc.inpRATNO}
\alias{hom.Sc.inpRHIOR}
\alias{hom.Sc.inpSACCE}
\alias{hom.Sc.inpSCHMA}
\alias{hom.Sc.inpSCHPO}
\alias{hom.Sc.inpSCLSC}
\alias{hom.Sc.inpSORBI}
\alias{hom.Sc.inpSTANO}
\alias{hom.Sc.inpSTRPU}
\alias{hom.Sc.inpTAKRU}
\alias{hom.Sc.inpTETTH}
\alias{hom.Sc.inpTETNI}
\alias{hom.Sc.inpTHAPS}
\alias{hom.Sc.inpTHEAN}
\alias{hom.Sc.inpTHEPA}
\alias{hom.Sc.inpTRICA}
\alias{hom.Sc.inpTRIVA}
\alias{hom.Sc.inpTRIAD}
\alias{hom.Sc.inpTRYCR}
\alias{hom.Sc.inpUSTMA}
\alias{hom.Sc.inpXENTR}
\alias{hom.Sc.inpYARLI}
\title{Map between IDs for genes in one organism to their predicted
  paralogs in another}
\description{ 
  A map of this type is an R object that provides mappings between
  identifiers for genes in the package organism and their predicted
  paralogs in the map that the organism is named after.  So for example,
  if the inparanoid package is the human package, then the
  hom.Sc.inpRATNO map would provide mappings between human and rat.
}
\details{
    Mappings between gene identifiers and their paralogs as predicted by
    the Inparanoid algorithm.  The map filters out paralogs that have an
    Inparanoid score less than 100%.

    Mappings are normally given from the ID of the organism in the
    package to the IDs of the organism listed in the map name.

    Reversal can be made of ANY map by using the function revmap (see
    examples below).

    Names for these maps are done in the "INPARANOID style" which means
    that they are normally the 1st three letters of the genus followed
    by the 1st two letters of the species.  For example: "Mus musculus"
    becomes "MUSMU", "Homo sapiens" becomes "HOMSA", "Monodelphis
    domestica" becomes "MONDO" etc. This means that for most of these
    organisms it will be possible to easily guess the abbreviations
    used.  An exception may occur in the future if a new model organism
    has a very similar genus and species name to an existing one.
}
\references{
\url{http://inparanoid.sbc.su.se/download/current/sqltables}
}
\examples{
        x <- hom.Sc.inpAPIME
        # Get honeybee IDs that are paralogous to the pkg IDs
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five genes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Now for the reverse map (honeybee IDs back to pkg paralog)
        x <- revmap(hom.Sc.inpAPIME)
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }         

    \dontrun{
        #For the most common organisms, we try to ensure that you can
        #map back to an Entrez Gene ID by providing you with necessary
        #maps in the related organism based annotation packages.  The
        #following example shows how to get from an Entrez Gene ID for
        #Human to Entrez Gene IDs for Mouse even though inparanoid does
        #not map to Entrez Gene IDs for either of these species.

        #You will have to include the appropriate packages for
        #humans:
        library("org.Hs.eg.db")
        #and for mouse:
        library("org.Mm.eg.db")
        #And of course you will need the inparanoid package:
        library("hom.Hs.inp.db")

        #Start with some Human Entrez Gene IDs
        humanEGIds <- c("4488","4487")

        #Inparanoid uses ensembl protein IDs so start with
        #those. Notice that there will be many protein IDs returned for
        #a typical gene since there are many possible translations.
        humanProtIds <- mget(humanEGIds,org.Hs.egENSEMBLPROT)

        #Map the IDs that we can from inparanoid. Notice that by design,
        #inparanoid only represents each gene product with a single
        #translation product. Therefore your list could slim down a lot
        #during this step.  Also, if the thing you are trying to match
        #up at this step has less than 100\% seed status, you will not
        #find it in this step.
        rawMouseProtIds <- mget(unlist(humanProtIds),hom.Hs.inpMUSMU,ifnotfound=NA)
        #This also means that we need to clean up the NAs from our result
        mouseProtIds <- rawMouseProtIds[!is.na(rawMouseProtIds)]

        #Then use the mouse organism based packages to convert these IDs
        #back to an Entrez Gene ID again (this time for mouse). 
        mouseEGIds <- mget(unlist(mouseProtIds),
                           org.Mm.egENSEMBLPROT2EG,ifnotfound=NA)
        #Now go ahead and have a look at the output
        mouseEGIds
    }

}
\keyword{datasets}

