
\name{hom.Dr.inp_dbconn}

\alias{hom.Dr.inp_dbconn}
\alias{hom.Dr.inp_dbfile}
\alias{hom.Dr.inp_dbschema}
\alias{hom.Dr.inp_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  hom.Dr.inp_dbconn()
  hom.Dr.inp_dbfile()
  hom.Dr.inp_dbschema(file="", show.indices=FALSE)
  hom.Dr.inp_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{hom.Dr.inp_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{hom.Dr.inp_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{hom.Dr.inp_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{hom.Dr.inp_dbschema} prints the schema definition of the
  package annotation DB.

  \code{hom.Dr.inp_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{hom.Dr.inp_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{hom.Dr.inp_dbfile}: a character string with the path to the
  package annotation DB.

  \code{hom.Dr.inp_dbschema}: none (invisible \code{NULL}).

  \code{hom.Dr.inp_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "metadata" table:
  dbGetQuery(hom.Dr.inp_dbconn(), "SELECT COUNT(*) FROM metadata")

  ## The connection object returned by hom.Dr.inp_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=hom.Dr.inp_dbfile(), cache_size=64000,
  synchronous=0)

  hom.Dr.inp_dbschema()

  hom.Dr.inp_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

