\name{hom.Dm.inpHOMSA}
\alias{hom.Dm.inpACYPI}
\alias{hom.Dm.inpAEDAE}
\alias{hom.Dm.inpANOGA}
\alias{hom.Dm.inpAPIME}
\alias{hom.Dm.inpARATH}
\alias{hom.Dm.inpASPFU}
\alias{hom.Dm.inpBATDE}
\alias{hom.Dm.inpBOMMO}
\alias{hom.Dm.inpBOSTA}
\alias{hom.Dm.inpBRAFL}
\alias{hom.Dm.inpBRUMA}
\alias{hom.Dm.inpCAEBRE}
\alias{hom.Dm.inpCAEBR}
\alias{hom.Dm.inpCAEEL}
\alias{hom.Dm.inpCAEJA}
\alias{hom.Dm.inpCAERE}
\alias{hom.Dm.inpCANAL}
\alias{hom.Dm.inpCANGL}
\alias{hom.Dm.inpCANFA}
\alias{hom.Dm.inpCAPSP}
\alias{hom.Dm.inpCAVPO}
\alias{hom.Dm.inpCHLRE}
\alias{hom.Dm.inpCIOIN}
\alias{hom.Dm.inpCIOSA}
\alias{hom.Dm.inpCOCIM}
\alias{hom.Dm.inpCOPCI}
\alias{hom.Dm.inpCRYNE}
\alias{hom.Dm.inpCRYHO}
\alias{hom.Dm.inpCRYPA}
\alias{hom.Dm.inpCULPI}
\alias{hom.Dm.inpCYAME}
\alias{hom.Dm.inpDANRE}
\alias{hom.Dm.inpDAPPU}
\alias{hom.Dm.inpDEBHA}
\alias{hom.Dm.inpDICDI}
\alias{hom.Dm.inpDROAN}
\alias{hom.Dm.inpDROGR}
\alias{hom.Dm.inpDROME}
\alias{hom.Dm.inpDROMO}
\alias{hom.Dm.inpDROPS}
\alias{hom.Dm.inpDROVI}
\alias{hom.Dm.inpDROWI}
\alias{hom.Dm.inpENTHI}
\alias{hom.Dm.inpEQUCA}
\alias{hom.Dm.inpESCCO}
\alias{hom.Dm.inpFUSGR}
\alias{hom.Dm.inpGALGA}
\alias{hom.Dm.inpGASAC}
\alias{hom.Dm.inpGIALA}
\alias{hom.Dm.inpHELRO}
\alias{hom.Dm.inpHOMSA}
\alias{hom.Dm.inpIXOSC}
\alias{hom.Dm.inpKLULA}
\alias{hom.Dm.inpLEIMA}
\alias{hom.Dm.inpLOTGI}
\alias{hom.Dm.inpMACMU}
\alias{hom.Dm.inpMAGGR}
\alias{hom.Dm.inpMONDO}
\alias{hom.Dm.inpMONBR}
\alias{hom.Dm.inpMUSMU}
\alias{hom.Dm.inpNASVI}
\alias{hom.Dm.inpNEMVE}
\alias{hom.Dm.inpNEUCR}
\alias{hom.Dm.inpORNAN}
\alias{hom.Dm.inpORYSA}
\alias{hom.Dm.inpORYLA}
\alias{hom.Dm.inpOSTTA}
\alias{hom.Dm.inpPANTR}
\alias{hom.Dm.inpPEDPA}
\alias{hom.Dm.inpPHYPA}
\alias{hom.Dm.inpPHYRA}
\alias{hom.Dm.inpPHYSO}
\alias{hom.Dm.inpPLAFA}
\alias{hom.Dm.inpPLAVI}
\alias{hom.Dm.inpPONPY}
\alias{hom.Dm.inpPOPTR}
\alias{hom.Dm.inpPRIPA}
\alias{hom.Dm.inpPUCGR}
\alias{hom.Dm.inpRATNO}
\alias{hom.Dm.inpRHIOR}
\alias{hom.Dm.inpSACCE}
\alias{hom.Dm.inpSCHMA}
\alias{hom.Dm.inpSCHPO}
\alias{hom.Dm.inpSCLSC}
\alias{hom.Dm.inpSORBI}
\alias{hom.Dm.inpSTANO}
\alias{hom.Dm.inpSTRPU}
\alias{hom.Dm.inpTAKRU}
\alias{hom.Dm.inpTETTH}
\alias{hom.Dm.inpTETNI}
\alias{hom.Dm.inpTHAPS}
\alias{hom.Dm.inpTHEAN}
\alias{hom.Dm.inpTHEPA}
\alias{hom.Dm.inpTRICA}
\alias{hom.Dm.inpTRIVA}
\alias{hom.Dm.inpTRIAD}
\alias{hom.Dm.inpTRYCR}
\alias{hom.Dm.inpUSTMA}
\alias{hom.Dm.inpXENTR}
\alias{hom.Dm.inpYARLI}
\title{Map between IDs for genes in one organism to their predicted
  paralogs in another}
\description{ 
  A map of this type is an R object that provides mappings between
  identifiers for genes in the package organism and their predicted
  paralogs in the map that the organism is named after.  So for example,
  if the inparanoid package is the human package, then the
  hom.Dm.inpRATNO map would provide mappings between human and rat.
}
\details{
    Mappings between gene identifiers and their paralogs as predicted by
    the Inparanoid algorithm.  The map filters out paralogs that have an
    Inparanoid score less than 100%.

    Mappings are normally given from the ID of the organism in the
    package to the IDs of the organism listed in the map name.

    Reversal can be made of ANY map by using the function revmap (see
    examples below).

    Names for these maps are done in the "INPARANOID style" which means
    that they are normally the 1st three letters of the genus followed
    by the 1st two letters of the species.  For example: "Mus musculus"
    becomes "MUSMU", "Homo sapiens" becomes "HOMSA", "Monodelphis
    domestica" becomes "MONDO" etc. This means that for most of these
    organisms it will be possible to easily guess the abbreviations
    used.  An exception may occur in the future if a new model organism
    has a very similar genus and species name to an existing one.
}
\references{
\url{http://inparanoid.sbc.su.se/download/current/sqltables}
}
\examples{
        x <- hom.Dm.inpAPIME
        # Get honeybee IDs that are paralogous to the pkg IDs
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five genes
          xx[1:5]
          # Get the first one
          xx[[1]]
        }

        #Now for the reverse map (honeybee IDs back to pkg paralog)
        x <- revmap(hom.Dm.inpAPIME)
        mapped_IDs <- mappedkeys(x)
        # Convert to a list
        xx <- as.list(x[mapped_IDs])
        if(length(xx) > 0) {
          # Get the paralogs for the first five IDs
          xx[1:5]
          # Get the first one
          xx[[1]]
        }         

    \dontrun{
        #For the most common organisms, we try to ensure that you can
        #map back to an Entrez Gene ID by providing you with necessary
        #maps in the related organism based annotation packages.  The
        #following example shows how to get from an Entrez Gene ID for
        #Human to Entrez Gene IDs for Mouse even though inparanoid does
        #not map to Entrez Gene IDs for either of these species.

        #You will have to include the appropriate packages for
        #humans:
        library("org.Hs.eg.db")
        #and for mouse:
        library("org.Mm.eg.db")
        #And of course you will need the inparanoid package:
        library("hom.Hs.inp.db")

        #Start with some Human Entrez Gene IDs
        humanEGIds <- c("4488","4487")

        #Inparanoid uses ensembl protein IDs so start with
        #those. Notice that there will be many protein IDs returned for
        #a typical gene since there are many possible translations.
        humanProtIds <- mget(humanEGIds,org.Hs.egENSEMBLPROT)

        #Map the IDs that we can from inparanoid. Notice that by design,
        #inparanoid only represents each gene product with a single
        #translation product. Therefore your list could slim down a lot
        #during this step.  Also, if the thing you are trying to match
        #up at this step has less than 100\% seed status, you will not
        #find it in this step.
        rawMouseProtIds <- mget(unlist(humanProtIds),hom.Hs.inpMUSMU,ifnotfound=NA)
        #This also means that we need to clean up the NAs from our result
        mouseProtIds <- rawMouseProtIds[!is.na(rawMouseProtIds)]

        #Then use the mouse organism based packages to convert these IDs
        #back to an Entrez Gene ID again (this time for mouse). 
        mouseEGIds <- mget(unlist(mouseProtIds),
                           org.Mm.egENSEMBLPROT2EG,ifnotfound=NA)
        #Now go ahead and have a look at the output
        mouseEGIds
    }

}
\keyword{datasets}

