datacache <- new.env(hash=TRUE, parent=emptyenv())

Roberts2005Annotation <- function() showQCData("Roberts2005Annotation", datacache)
Roberts2005Annotation_dbconn <- function() dbconn(datacache)
Roberts2005Annotation_dbfile <- function() dbfile(datacache)
Roberts2005Annotation_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
Roberts2005Annotation_dbInfo <- function() dbInfo(datacache)

Roberts2005AnnotationORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "Roberts2005Annotation.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "Roberts2005Annotation", "chip Roberts2005Annotation", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("Roberts2005Annotation.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(Roberts2005Annotation_dbconn())
}

