
\name{PFAM_dbconn}

\alias{PFAM_dbconn}
\alias{PFAM_dbfile}
\alias{PFAM_dbschema}
\alias{PFAM_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  PFAM_dbconn()
  PFAM_dbfile()
  PFAM_dbschema(file="", show.indices=FALSE)
  PFAM_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{PFAM_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{PFAM_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{PFAM_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{PFAM_dbschema} prints the schema definition of the
  package annotation DB.

  \code{PFAM_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{PFAM_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{PFAM_dbfile}: a character string with the path to the
  package annotation DB.

  \code{PFAM_dbschema}: none (invisible \code{NULL}).

  \code{PFAM_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  ## Count the number of rows in the "de" table:
  dbGetQuery(PFAM_dbconn(), "SELECT COUNT(*) FROM de;")

  ## The connection object returned by PFAM_dbconn() was
  ## created with:
  dbConnect(SQLite(), dbname=PFAM_dbfile(), cache_size=64000,
  synchronous=0)

  PFAM_dbschema()

  PFAM_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

