

#### Prepare reference queries from PANTHER webservice 18.09.2013 ####
#results will be used for Unit Tests
if(F){
  library(RCurl)
  
  url <- 'http://www.pantherdb.org/webservices/garuda/search.jsp?keyword='
  ids <- keys(PANTHER.db,"UNIPROT")[c(50,70,65490)];ids
  
  fullUrl <- paste0(url,paste(ids, collapse="|"),'&listType=gene&type=getList')
  gs<-read.delim(fullUrl,stringsAsFactors=F)$Gene.Symbol
  
  fullUrl <- paste0(url,paste(ids, collapse="+or+"),'&listType=pathway&type=getList')
  path_acc<-read.delim(fullUrl,stringsAsFactors=F)$Pathway.Accession
  
  fullUrl <- paste0(url,paste(ids, collapse="+or+"),'&listType=family&type=getList')
  fam_acc<-read.delim(fullUrl,stringsAsFactors=F)$Family.Accession
  
  fullUrl <- paste0(url,paste(ids, collapse="+or+"),'&listType=category&type=getList')
  cat_acc<-read.delim(fullUrl,stringsAsFactors=F)$Category.Accession
}
### ###


test_structure <- function(){
  checkEquals(keytypes(PANTHER.db),c("FAMILY_ID","GOSLIM_ID","CLASS_ID","PATHWAY_ID","COMPONENT_ID","UNIPROT","SPECIES","ENTREZ"))
	checkEquals(columns(PANTHER.db),c('FAMILY_ID','GOSLIM_ID','GOSLIM_TERM','UNIPROT','SPECIES','FAMILY_TERM','SUBFAMILY_TERM','CLASS_ID','CLASS_TERM','PATHWAY_ID','PATHWAY_TERM','COMPONENT_ID','COMPONENT_TERM','EVIDENCE','EVIDENCE_TYPE','CONFIDENCE_CODE','ENTREZ'))
}


test_select_vs_webquery <- function(){

  ids<-"PTHR10079"
  webquery<-sprintf("http://www.pantherdb.org/webservices/garuda/search.jsp?keyword=%s&listType=category&type=getList",ids)
  #read.delim(webquery)
	#webquery result on 27.06.2014:  
  response<-"Category Accession Category Name GO:0000165 MAPK cascade GO:0005102 receptor binding GO:0005125 cytokine activity GO:0005126 cytokine receptor binding GO:0005135 interleukin-3 receptor binding GO:0005488 binding GO:0005515 protein binding GO:0007154 cell communication GO:0007165 signal transduction GO:0007166 cell surface receptor signaling pathway GO:0007259 JAK-STAT cascade GO:0007267 cell-cell signaling GO:0008083 growth factor activity GO:0009987 cellular process GO:0019221 cytokine-mediated signaling pathway GO:0035556 intracellular signal transduction PC00083 cytokine PC00128 interleukin superfamily PC00207 signaling molecule"
  webquery_res<-grep("^GO:|^PC[0-9]",unlist(strsplit(response," ")),v=T)
    
  select_res<-sort(c(select(PANTHER.db,keys=ids,columns="GOSLIM_ID")$GOSLIM_ID,select(PANTHER.db,keys=ids,columns="CLASS_ID")$CLASS_ID))
  checkEquals(webquery_res,select_res)
  
  ids<-"PC00015"
  webquery<-sprintf("http://www.pantherdb.org/webservices/garuda/search.jsp?keyword=%s&listType=family&type=getList",ids)
  #read.delim(webquery)
  #webquery result on 27.06.2014:  
  response<-"Family Accession Family Name PTHR11352 PROLIFERATING CELL NUCLEAR ANTIGEN PTHR11352:SF0 PROLIFERATING CELL NUCLEAR ANTIGEN PTHR11352:SF1 SUBFAMILY NOT NAMED PTHR11352:SF2 SUBFAMILY NOT NAMED "
  webquery_res<-grep("^PTHR[0-9]",unlist(strsplit(response," ")),v=T)
  
  select_res<-sort(select(PANTHER.db,keys=ids,columns="FAMILY_ID",keytype="CLASS_ID")$FAMILY_ID)
  checkEquals(webquery_res,select_res)
  
  ids<-c("A0JM86","A0JMJ1","F1PB63")
  
  webquery<-sprintf("http://www.pantherdb.org/webservices/garuda/search.jsp?keyword=%s&listType=pathway&type=getList",paste(ids,collapse="+or+"))
  #read.delim(webquery)
  #webquery result on 27.06.2014:  
  response<-"Pathway Accession Pathway Name Author P00029 Huntington disease Christina Wilson P06664 Gonadotropin-releasing hormone receptor pathway - "
  webquery_res<-grep("^P[0-9]+",unlist(strsplit(response," ")),v=T)
  
  select_res<-sort(select(PANTHER.db,keys=ids,columns="PATHWAY_ID",keytype="UNIPROT")$PATHWAY_ID)
  checkEquals(webquery_res,select_res)
  
}


test_switch_species <- function(){
  species(PANTHER.db) <- "HUMAN"  
}
