## ----loadPkg-------------------------------------------------------------
library(PANTHER.db)

## ----help,eval=FALSE-----------------------------------------------------
#  help("PANTHER.db")

## ----show----------------------------------------------------------------
PANTHER.db

## ----availSpecies--------------------------------------------------------
availablePantherSpecies(PANTHER.db)

## ----setTaxID------------------------------------------------------------
species(PANTHER.db) <- "HUMAN"
PANTHER.db
resetSpecies(PANTHER.db)
PANTHER.db

## ----columns-------------------------------------------------------------
columns(PANTHER.db)

## ----keytypes------------------------------------------------------------
keytypes(PANTHER.db)

## ----keys----------------------------------------------------------------
go_ids<-head(keys(PANTHER.db,keytype="GOSLIM_ID"))
go_ids

## ----select--------------------------------------------------------------
cols <- c("FAMILY_ID","CLASS_ID")
res <- select(PANTHER.db, keys=go_ids, columns=cols,keytype="GOSLIM_ID")
head(res)

## ----traverseClassTree---------------------------------------------------
term<-"PC00209"
select(PANTHER.db,term, "CLASS_TERM","CLASS_ID")

ancestors<-traverseClassTree(PANTHER.db,term,scope="ANCESTOR")
select(PANTHER.db,ancestors, "CLASS_TERM","CLASS_ID")

parents<-traverseClassTree(PANTHER.db,term,scope="PARENT")
select(PANTHER.db,parents, "CLASS_TERM","CLASS_ID")

children<-traverseClassTree(PANTHER.db,term,scope="CHILD")
select(PANTHER.db,children, "CLASS_TERM","CLASS_ID")

offspring<-traverseClassTree(PANTHER.db,term,scope="OFFSPRING")
select(PANTHER.db,offspring, "CLASS_TERM","CLASS_ID")

