datacache <- new.env(hash=TRUE, parent=emptyenv())

Hs6UG171 <- function() showQCData("Hs6UG171", datacache)
Hs6UG171_dbconn <- function() dbconn(datacache)
Hs6UG171_dbfile <- function() dbfile(datacache)
Hs6UG171_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
Hs6UG171_dbInfo <- function() dbInfo(datacache)

Hs6UG171ORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "Hs6UG171.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "Hs6UG171", "chip Hs6UG171", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("Hs6UG171.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(Hs6UG171_dbconn())
}

